/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.origin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.boot.origin.OriginProvider;

public interface Origin {
    default public Origin getParent() {
        return null;
    }

    public static Origin from(Object source2) {
        if (source2 instanceof Origin) {
            Origin origin = (Origin)source2;
            return origin;
        }
        Origin origin = null;
        if (source2 instanceof OriginProvider) {
            OriginProvider originProvider = (OriginProvider)source2;
            origin = originProvider.getOrigin();
        }
        if (origin == null && source2 instanceof Throwable) {
            Throwable throwable = (Throwable)source2;
            return Origin.from(throwable.getCause());
        }
        return origin;
    }

    public static List<Origin> parentsFrom(Object source2) {
        Origin origin = Origin.from(source2);
        if (origin == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<Origin> parents = new LinkedHashSet<Origin>();
        for (origin = origin.getParent(); origin != null && !parents.contains(origin); origin = origin.getParent()) {
            parents.add(origin);
        }
        return Collections.unmodifiableList(new ArrayList(parents));
    }
}

