/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CompletionStage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.event.EventExpressionEvaluator;
import org.springframework.context.event.EventListener;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFuture;

public class ApplicationListenerMethodAdapter
implements GenericApplicationListener {
    private static final boolean reactiveStreamsPresent = ClassUtils.isPresent("org.reactivestreams.Publisher", ApplicationListenerMethodAdapter.class.getClassLoader());
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String beanName;
    private final Method method;
    private final Method targetMethod;
    private final AnnotatedElementKey methodKey;
    private final List<ResolvableType> declaredEventTypes;
    @Nullable
    private final String condition;
    private final boolean defaultExecution;
    private final int order;
    @Nullable
    private volatile String listenerId;
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private EventExpressionEvaluator evaluator;

    public ApplicationListenerMethodAdapter(String beanName, Class<?> targetClass, Method method) {
        this.beanName = beanName;
        this.method = BridgeMethodResolver.findBridgedMethod(method);
        this.targetMethod = !Proxy.isProxyClass(targetClass) ? AopUtils.getMostSpecificMethod(method, targetClass) : this.method;
        this.methodKey = new AnnotatedElementKey(this.targetMethod, targetClass);
        EventListener ann = AnnotatedElementUtils.findMergedAnnotation(this.targetMethod, EventListener.class);
        this.declaredEventTypes = ApplicationListenerMethodAdapter.resolveDeclaredEventTypes(method, ann);
        this.condition = ann != null ? ann.condition() : null;
        this.defaultExecution = ann == null || ann.defaultExecution();
        this.order = ApplicationListenerMethodAdapter.resolveOrder(this.targetMethod);
        String id = ann != null ? ann.id() : "";
        this.listenerId = !id.isEmpty() ? id : null;
    }

    private static List<ResolvableType> resolveDeclaredEventTypes(Method method, @Nullable EventListener ann) {
        Class<?>[] classes;
        int count;
        int n = count = KotlinDetector.isSuspendingFunction(method) ? method.getParameterCount() - 1 : method.getParameterCount();
        if (count > 1) {
            throw new IllegalStateException("Maximum one parameter is allowed for event listener method: " + String.valueOf(method));
        }
        if (ann != null && (classes = ann.classes()).length > 0) {
            ArrayList<ResolvableType> types = new ArrayList<ResolvableType>(classes.length);
            for (Class<?> eventType : classes) {
                types.add(ResolvableType.forClass(eventType));
            }
            return types;
        }
        if (count == 0) {
            throw new IllegalStateException("Event parameter is mandatory for event listener method: " + String.valueOf(method));
        }
        return Collections.singletonList(ResolvableType.forMethodParameter(method, 0));
    }

    private static int resolveOrder(Method method) {
        Order ann = AnnotatedElementUtils.findMergedAnnotation(method, Order.class);
        return ann != null ? ann.value() : Integer.MAX_VALUE;
    }

    void init(ApplicationContext applicationContext, @Nullable EventExpressionEvaluator evaluator) {
        this.applicationContext = applicationContext;
        this.evaluator = evaluator;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        if (this.isDefaultExecution()) {
            this.processEvent(event);
        }
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        for (ResolvableType declaredEventType : this.declaredEventTypes) {
            if (eventType.hasUnresolvableGenerics() ? declaredEventType.toClass().isAssignableFrom(eventType.toClass()) : declaredEventType.isAssignableFrom(eventType)) {
                return true;
            }
            if (!PayloadApplicationEvent.class.isAssignableFrom(eventType.toClass())) continue;
            ResolvableType payloadType = eventType.as(PayloadApplicationEvent.class).getGeneric(new int[0]);
            if (declaredEventType.isAssignableFrom(payloadType)) {
                return true;
            }
            if (payloadType.resolve() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsSourceType(@Nullable Class<?> sourceType) {
        return true;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getListenerId() {
        String id = this.listenerId;
        if (id == null) {
            this.listenerId = id = this.getDefaultListenerId();
        }
        return id;
    }

    protected String getDefaultListenerId() {
        Method method = this.getTargetMethod();
        StringJoiner sj = new StringJoiner(",", "(", ")");
        for (Class<?> paramType : method.getParameterTypes()) {
            sj.add(paramType.getName());
        }
        return ClassUtils.getQualifiedMethodName(method) + String.valueOf(sj);
    }

    protected boolean isDefaultExecution() {
        return this.defaultExecution;
    }

    public void processEvent(ApplicationEvent event) {
        Object[] args2 = this.resolveArguments(event);
        if (this.shouldHandle(event, args2)) {
            Object result = this.doInvoke(args2);
            if (result != null) {
                this.handleResult(result);
            } else {
                this.logger.trace("No result object given - no result to handle");
            }
        }
    }

    public boolean shouldHandle(ApplicationEvent event) {
        return this.shouldHandle(event, this.resolveArguments(event));
    }

    private boolean shouldHandle(ApplicationEvent event, @Nullable Object[] args2) {
        if (args2 == null) {
            return false;
        }
        String condition = this.getCondition();
        if (StringUtils.hasText(condition)) {
            Assert.notNull((Object)this.evaluator, "EventExpressionEvaluator must not be null");
            return this.evaluator.condition(condition, event, this.targetMethod, this.methodKey, args2);
        }
        return true;
    }

    @Nullable
    protected Object[] resolveArguments(ApplicationEvent event) {
        PayloadApplicationEvent payloadEvent;
        Object payload;
        ResolvableType declaredEventType = this.getResolvableType(event);
        if (declaredEventType == null) {
            return null;
        }
        if (this.method.getParameterCount() == 0) {
            return new Object[0];
        }
        Class<?> declaredEventClass = declaredEventType.toClass();
        if (!ApplicationEvent.class.isAssignableFrom(declaredEventClass) && event instanceof PayloadApplicationEvent && declaredEventClass.isInstance(payload = (payloadEvent = (PayloadApplicationEvent)event).getPayload())) {
            return new Object[]{payload};
        }
        return new Object[]{event};
    }

    protected void handleResult(Object result) {
        if (reactiveStreamsPresent && new ReactiveResultHandler().subscribeToPublisher(result)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Adapted to reactive result: " + String.valueOf(result));
            }
        } else if (result instanceof CompletionStage) {
            CompletionStage completionStage = (CompletionStage)result;
            completionStage.whenComplete((event, ex) -> {
                if (ex != null) {
                    this.handleAsyncError((Throwable)ex);
                } else if (event != null) {
                    this.publishEvents(event);
                }
            });
        } else if (result instanceof ListenableFuture) {
            ListenableFuture listenableFuture = (ListenableFuture)result;
            listenableFuture.addCallback(this::publishEvents, this::handleAsyncError);
        } else {
            this.publishEvents(result);
        }
    }

    private void publishEvents(@Nullable Object result) {
        if (result != null && result.getClass().isArray()) {
            Object[] events;
            for (Object event : events = ObjectUtils.toObjectArray(result)) {
                this.publishEvent(event);
            }
        } else if (result instanceof Collection) {
            Collection events = (Collection)result;
            for (Object event : events) {
                this.publishEvent(event);
            }
        } else {
            this.publishEvent(result);
        }
    }

    private void publishEvent(@Nullable Object event) {
        if (event != null) {
            Assert.notNull((Object)this.applicationContext, "ApplicationContext must not be null");
            this.applicationContext.publishEvent(event);
        }
    }

    protected void handleAsyncError(Throwable t) {
        this.logger.error("Unexpected error occurred in asynchronous listener", t);
    }

    @Nullable
    protected Object doInvoke(Object ... args2) {
        Object bean2 = this.getTargetBean();
        if (bean2.equals(null)) {
            return null;
        }
        try {
            ReflectionUtils.makeAccessible(this.method);
            if (KotlinDetector.isSuspendingFunction(this.method)) {
                return CoroutinesUtils.invokeSuspendingFunction(this.method, bean2, args2);
            }
            return this.method.invoke(bean2, args2);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(this.method, bean2, args2);
            throw new IllegalStateException(this.getInvocationErrorMessage(bean2, ex.getMessage(), args2), ex);
        }
        catch (IllegalAccessException | InaccessibleObjectException ex) {
            throw new IllegalStateException(this.getInvocationErrorMessage(bean2, ex.getMessage(), args2), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)targetException;
                throw runtimeException;
            }
            String msg = this.getInvocationErrorMessage(bean2, "Failed to invoke event listener method", args2);
            throw new UndeclaredThrowableException(targetException, msg);
        }
    }

    protected Object getTargetBean() {
        Assert.notNull((Object)this.applicationContext, "ApplicationContext must not be null");
        return this.applicationContext.getBean(this.beanName);
    }

    protected Method getTargetMethod() {
        return this.targetMethod;
    }

    @Nullable
    protected String getCondition() {
        return this.condition;
    }

    protected String getDetailedErrorMessage(Object bean2, @Nullable String message) {
        StringBuilder sb = StringUtils.hasLength(message) ? new StringBuilder(message).append('\n') : new StringBuilder();
        sb.append("HandlerMethod details: \n");
        sb.append("Bean [").append(bean2.getClass().getName()).append("]\n");
        sb.append("Method [").append(this.method.toGenericString()).append("]\n");
        return sb.toString();
    }

    private void assertTargetBean(Method method, Object targetBean, @Nullable Object[] args2) {
        Class<?> targetBeanClass;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (!methodDeclaringClass.isAssignableFrom(targetBeanClass = targetBean.getClass())) {
            String msg = "The event listener method class '" + methodDeclaringClass.getName() + "' is not an instance of the actual bean class '" + targetBeanClass.getName() + "'. If the bean requires proxying (for example, due to @Transactional), please use class-based proxying.";
            throw new IllegalStateException(this.getInvocationErrorMessage(targetBean, msg, args2));
        }
    }

    private String getInvocationErrorMessage(Object bean2, @Nullable String message, @Nullable Object[] resolvedArgs) {
        StringBuilder sb = new StringBuilder(this.getDetailedErrorMessage(bean2, message));
        sb.append("Resolved arguments: \n");
        for (int i2 = 0; i2 < resolvedArgs.length; ++i2) {
            sb.append('[').append(i2).append("] ");
            if (resolvedArgs[i2] == null) {
                sb.append("[null] \n");
                continue;
            }
            sb.append("[type=").append(resolvedArgs[i2].getClass().getName()).append("] ");
            sb.append("[value=").append(resolvedArgs[i2]).append("]\n");
        }
        return sb.toString();
    }

    @Nullable
    private ResolvableType getResolvableType(ApplicationEvent event) {
        PayloadApplicationEvent payloadEvent;
        ResolvableType eventType;
        ResolvableType payloadType = null;
        if (event instanceof PayloadApplicationEvent && (eventType = (payloadEvent = (PayloadApplicationEvent)event).getResolvableType()) != null) {
            payloadType = eventType.as(PayloadApplicationEvent.class).getGeneric(new int[0]);
        }
        for (ResolvableType declaredEventType : this.declaredEventTypes) {
            Class<?> eventClass = declaredEventType.toClass();
            if (!ApplicationEvent.class.isAssignableFrom(eventClass) && payloadType != null && declaredEventType.isAssignableFrom(payloadType)) {
                return declaredEventType;
            }
            if (!eventClass.isInstance(event)) continue;
            return declaredEventType;
        }
        return null;
    }

    public String toString() {
        return this.method.toGenericString();
    }

    private class ReactiveResultHandler {
        private ReactiveResultHandler() {
        }

        public boolean subscribeToPublisher(Object result) {
            ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(result.getClass());
            if (adapter != null) {
                adapter.toPublisher(result).subscribe((Subscriber)new EventPublicationSubscriber());
                return true;
            }
            return false;
        }
    }

    private class EventPublicationSubscriber
    implements Subscriber<Object> {
        private EventPublicationSubscriber() {
        }

        public void onSubscribe(Subscription s) {
            s.request(Integer.MAX_VALUE);
        }

        public void onNext(Object o) {
            ApplicationListenerMethodAdapter.this.publishEvents(o);
        }

        public void onError(Throwable t) {
            ApplicationListenerMethodAdapter.this.handleAsyncError(t);
        }

        public void onComplete() {
        }
    }
}

