/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.EventExpressionRootObject;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.context.expression.CachedExpressionEvaluator;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class EventExpressionEvaluator
extends CachedExpressionEvaluator {
    private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> conditionCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>(64);
    private final StandardEvaluationContext originalEvaluationContext;

    EventExpressionEvaluator(StandardEvaluationContext originalEvaluationContext) {
        this.originalEvaluationContext = originalEvaluationContext;
    }

    public boolean condition(String conditionExpression, ApplicationEvent event, Method targetMethod, AnnotatedElementKey methodKey, Object[] args2) {
        EventExpressionRootObject rootObject = new EventExpressionRootObject(event, args2);
        EvaluationContext evaluationContext = this.createEvaluationContext(rootObject, targetMethod, args2);
        return Boolean.TRUE.equals(this.getExpression(this.conditionCache, methodKey, conditionExpression).getValue(evaluationContext, Boolean.class));
    }

    private EvaluationContext createEvaluationContext(EventExpressionRootObject rootObject, Method method, Object[] args2) {
        MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext(rootObject, method, args2, this.getParameterNameDiscoverer());
        this.originalEvaluationContext.applyDelegatesTo(evaluationContext);
        return evaluationContext;
    }
}

