/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.core.task.TaskDecorator;
import org.springframework.util.Assert;

public class CompositeTaskDecorator
implements TaskDecorator {
    private final List<TaskDecorator> taskDecorators;

    public CompositeTaskDecorator(Collection<? extends TaskDecorator> taskDecorators) {
        Assert.notNull(taskDecorators, "TaskDecorators must not be null");
        this.taskDecorators = new ArrayList<TaskDecorator>(taskDecorators);
    }

    @Override
    public Runnable decorate(Runnable runnable2) {
        Assert.notNull((Object)runnable2, "Runnable must not be null");
        for (TaskDecorator taskDecorator : this.taskDecorators) {
            runnable2 = taskDecorator.decorate(runnable2);
        }
        return runnable2;
    }
}

