/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.ee10.servlet.HttpOutput;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;

public class JettyHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public JettyHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServletServerHttpResponse createResponse(HttpServletResponse response, AsyncContext context, ServletServerHttpRequest request) throws IOException {
        return new Jetty12ServerHttpResponse(response, context, this.getDataBufferFactory(), this.getBufferSize(), request);
    }

    private static final class Jetty12ServerHttpResponse
    extends ServletServerHttpResponse {
        Jetty12ServerHttpResponse(HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(response, asyncContext, bufferFactory, bufferSize, request);
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ServletOutputStream output = this.getOutputStream();
            if (output instanceof HttpOutput) {
                HttpOutput httpOutput = (HttpOutput)output;
                int len = 0;
                try (DataBuffer.ByteBufferIterator iterator2 = dataBuffer.readableByteBuffers();){
                    while (iterator2.hasNext() && httpOutput.isReady()) {
                        ByteBuffer byteBuffer = (ByteBuffer)iterator2.next();
                        len += byteBuffer.remaining();
                        httpOutput.write(byteBuffer);
                    }
                }
                return len;
            }
            return super.writeToOutputStream(dataBuffer);
        }
    }
}

