/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.backoff;

import java.util.function.Supplier;
import org.springframework.retry.backoff.BackOffInterruptedException;
import org.springframework.retry.backoff.Sleeper;
import org.springframework.retry.backoff.SleepingBackOffPolicy;
import org.springframework.retry.backoff.StatelessBackOffPolicy;
import org.springframework.retry.backoff.ThreadWaitSleeper;
import org.springframework.util.Assert;

public class FixedBackOffPolicy
extends StatelessBackOffPolicy
implements SleepingBackOffPolicy<FixedBackOffPolicy> {
    private static final long DEFAULT_BACK_OFF_PERIOD = 1000L;
    private Supplier<Long> backOffPeriod = () -> 1000L;
    private Sleeper sleeper = new ThreadWaitSleeper();

    @Override
    public FixedBackOffPolicy withSleeper(Sleeper sleeper) {
        FixedBackOffPolicy res = new FixedBackOffPolicy();
        res.backOffPeriodSupplier(this.backOffPeriod);
        res.setSleeper(sleeper);
        return res;
    }

    public void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    public void setBackOffPeriod(long backOffPeriod) {
        this.backOffPeriod = () -> backOffPeriod > 0L ? backOffPeriod : 1L;
    }

    public void backOffPeriodSupplier(Supplier<Long> backOffPeriodSupplier) {
        Assert.notNull(backOffPeriodSupplier, "'backOffPeriodSupplier' cannot be null");
        this.backOffPeriod = backOffPeriodSupplier;
    }

    public long getBackOffPeriod() {
        return this.backOffPeriod.get();
    }

    @Override
    protected void doBackOff() throws BackOffInterruptedException {
        try {
            this.sleeper.sleep(this.backOffPeriod.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BackOffInterruptedException("Thread interrupted while sleeping", e);
        }
    }

    public String toString() {
        return "FixedBackOffPolicy[backOffPeriod=" + String.valueOf(this.backOffPeriod.get()) + "]";
    }
}

