/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.support;

import java.net.URI;
import java.util.ArrayList;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.util.UriBuilderFactory;

public final class RestTemplateAdapter
implements HttpExchangeAdapter {
    private final RestTemplate restTemplate;

    private RestTemplateAdapter(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public boolean supportsRequestAttributes() {
        return false;
    }

    @Override
    public void exchange(HttpRequestValues values2) {
        this.restTemplate.exchange(this.newRequest(values2), Void.class);
    }

    @Override
    public HttpHeaders exchangeForHeaders(HttpRequestValues values2) {
        return this.restTemplate.exchange(this.newRequest(values2), Void.class).getHeaders();
    }

    @Override
    @Nullable
    public <T> T exchangeForBody(HttpRequestValues values2, ParameterizedTypeReference<T> bodyType) {
        return this.restTemplate.exchange(this.newRequest(values2), bodyType).getBody();
    }

    @Override
    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues values2) {
        return this.restTemplate.exchange(this.newRequest(values2), Void.class);
    }

    @Override
    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues values2, ParameterizedTypeReference<T> bodyType) {
        return this.restTemplate.exchange(this.newRequest(values2), bodyType);
    }

    private <B> RequestEntity<?> newRequest(HttpRequestValues values2) {
        Object body2;
        RequestEntity.BodyBuilder builder;
        HttpMethod httpMethod = values2.getHttpMethod();
        Assert.notNull((Object)httpMethod, "HttpMethod is required");
        if (values2.getUri() != null) {
            builder = RequestEntity.method(httpMethod, values2.getUri());
        } else if (values2.getUriTemplate() != null) {
            UriBuilderFactory uriBuilderFactory = values2.getUriBuilderFactory();
            if (uriBuilderFactory != null) {
                URI expanded = uriBuilderFactory.expand(values2.getUriTemplate(), values2.getUriVariables());
                builder = RequestEntity.method(httpMethod, expanded);
            } else {
                builder = RequestEntity.method(httpMethod, values2.getUriTemplate(), values2.getUriVariables());
            }
        } else {
            throw new IllegalStateException("Neither full URL nor URI template");
        }
        builder.headers(values2.getHeaders());
        if (!values2.getCookies().isEmpty()) {
            ArrayList cookies = new ArrayList();
            values2.getCookies().forEach((name, cookieValues) -> cookieValues.forEach(value -> {
                HttpCookie cookie = new HttpCookie((String)name, (String)value);
                cookies.add(cookie.toString());
            }));
            builder.header("Cookie", String.join((CharSequence)"; ", cookies));
        }
        if ((body2 = values2.getBodyValue()) == null) {
            return builder.build();
        }
        if (values2.getBodyValueType() != null) {
            return builder.body(body2, values2.getBodyValueType().getType());
        }
        return builder.body(body2);
    }

    public static RestTemplateAdapter create(RestTemplate restTemplate) {
        return new RestTemplateAdapter(restTemplate);
    }
}

