/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.function.CompletedAsyncServerResponse;
import org.springframework.web.servlet.function.DefaultAsyncServerResponse;
import org.springframework.web.servlet.function.ServerResponse;

public interface AsyncServerResponse
extends ServerResponse {
    public ServerResponse block();

    public static AsyncServerResponse create(Object asyncResponse) {
        return AsyncServerResponse.createInternal(asyncResponse, null);
    }

    public static AsyncServerResponse create(Object asyncResponse, Duration timeout2) {
        return AsyncServerResponse.createInternal(asyncResponse, timeout2);
    }

    private static AsyncServerResponse createInternal(Object asyncResponse, @Nullable Duration timeout2) {
        Assert.notNull(asyncResponse, "AsyncResponse must not be null");
        CompletableFuture<ServerResponse> futureResponse = AsyncServerResponse.toCompletableFuture(asyncResponse);
        if (futureResponse.isDone() && !futureResponse.isCancelled() && !futureResponse.isCompletedExceptionally()) {
            try {
                ServerResponse completedResponse = futureResponse.get();
                return new CompletedAsyncServerResponse(completedResponse);
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return new DefaultAsyncServerResponse(futureResponse, timeout2);
    }

    private static CompletableFuture<ServerResponse> toCompletableFuture(Object obj) {
        ReactiveAdapterRegistry registry;
        ReactiveAdapter publisherAdapter;
        if (obj instanceof CompletableFuture) {
            CompletableFuture futureResponse = (CompletableFuture)obj;
            return futureResponse;
        }
        if (DefaultAsyncServerResponse.reactiveStreamsPresent && (publisherAdapter = (registry = ReactiveAdapterRegistry.getSharedInstance()).getAdapter(obj.getClass())) != null) {
            Publisher publisher = publisherAdapter.toPublisher(obj);
            ReactiveAdapter futureAdapter = registry.getAdapter(CompletableFuture.class);
            if (futureAdapter != null) {
                return (CompletableFuture)futureAdapter.fromPublisher(publisher);
            }
        }
        throw new IllegalArgumentException("Asynchronous type not supported: " + String.valueOf(obj.getClass()));
    }
}

