/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractStandardUpgradeStrategy;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

public class StandardWebSocketUpgradeStrategy
extends AbstractStandardUpgradeStrategy {
    private static final String[] SUPPORTED_VERSIONS = new String[]{"13"};

    @Override
    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    @Override
    protected void upgradeInternal(ServerHttpRequest request, ServerHttpResponse response, @Nullable String selectedProtocol, List<Extension> selectedExtensions, Endpoint endpoint) throws HandshakeFailureException {
        HttpServletRequest servletRequest = this.getHttpServletRequest(request);
        HttpServletResponse servletResponse = this.getHttpServletResponse(response);
        StringBuffer requestUrl = servletRequest.getRequestURL();
        String path = servletRequest.getRequestURI();
        Map<String, String> pathParams = Collections.emptyMap();
        ServerEndpointRegistration endpointConfig = new ServerEndpointRegistration(path, endpoint);
        endpointConfig.setSubprotocols(Collections.singletonList(selectedProtocol));
        endpointConfig.setExtensions(selectedExtensions);
        try {
            this.upgradeHttpToWebSocket(servletRequest, servletResponse, endpointConfig, pathParams);
        }
        catch (Exception ex) {
            throw new HandshakeFailureException("Servlet request failed to upgrade to WebSocket: " + String.valueOf(requestUrl), ex);
        }
    }

    protected void upgradeHttpToWebSocket(HttpServletRequest request, HttpServletResponse response, ServerEndpointConfig endpointConfig, Map<String, String> pathParams) throws Exception {
        this.getContainer(request).upgradeHttpToWebSocket(request, response, endpointConfig, pathParams);
    }
}

