/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application;

import java.util.Objects;
import nostr.base.Signature;
import nostr.event.BaseEvent;
import xyz.tcheeric.identity.api.exceptions.IdentityNotFoundException;
import xyz.tcheeric.identity.api.ports.IdentityRepository;
import xyz.tcheeric.identity.domain.Identity;

public class SignEventUseCase {
    private final IdentityRepository repository;

    public SignEventUseCase(IdentityRepository repository) {
        this.repository = Objects.requireNonNull(repository, "IdentityRepository cannot be null");
    }

    public Signature execute(String identityId, BaseEvent event) {
        Objects.requireNonNull(identityId, "Identity ID cannot be null");
        Objects.requireNonNull(event, "Event cannot be null");
        Identity identity = this.repository.findById(identityId).orElseThrow(() -> new IdentityNotFoundException(identityId));
        Signature signature = identity.sign(event);
        this.repository.save(identity);
        return signature;
    }
}

