/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.bunker;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.exceptions.IdentityException;
import xyz.tcheeric.identity.api.ports.BunkerConnectionPort;
import xyz.tcheeric.identity.api.ports.BunkerIdentityRepository;
import xyz.tcheeric.identity.domain.BunkerIdentity;

public class CreateBunkerIdentityUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateBunkerIdentityUseCase.class);
    private final BunkerConnectionPort connectionPort;
    private final BunkerIdentityRepository identityRepository;

    public CreateBunkerIdentityUseCase(BunkerConnectionPort connectionPort, BunkerIdentityRepository identityRepository) {
        this.connectionPort = Objects.requireNonNull(connectionPort, "Connection port cannot be null");
        this.identityRepository = Objects.requireNonNull(identityRepository, "Identity repository cannot be null");
    }

    public CompletableFuture<BunkerIdentity> execute(String keyName) {
        return this.execute(keyName, null);
    }

    public CompletableFuture<BunkerIdentity> execute(String keyName, String passphrase) {
        return this.execute(keyName, passphrase, null, null);
    }

    public CompletableFuture<BunkerIdentity> execute(String keyName, String passphrase, String description, String lightningAddress) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.info("create_bunker_identity_started key_name={} has_passphrase={} has_lightning_address={}", keyName, passphrase != null, lightningAddress != null);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.identityRepository.existsByKeyName(keyName).thenCompose(exists -> {
            if (exists.booleanValue()) {
                LOGGER.warn("create_bunker_identity_rejected key_name={} reason=already_exists", (Object)keyName);
                return CompletableFuture.failedFuture(new IdentityException("An identity with key name '" + keyName + "' already exists. Suggestion: Use a different key name or delete the existing identity first."));
            }
            return this.createKeyInBunker(keyName, passphrase);
        })).thenApply(identity -> {
            BunkerIdentity enriched = identity;
            if (description != null) {
                enriched = enriched.withDescription(description);
            }
            if (lightningAddress != null) {
                enriched = enriched.withLightningAddress(lightningAddress);
            }
            return enriched;
        })).thenCompose(identity -> this.persistIdentity((BunkerIdentity)identity))).whenComplete((identity, ex) -> {
            if (ex != null) {
                LOGGER.error("create_bunker_identity_failed key_name={} error={}", (Object)keyName, (Object)ex.getMessage());
            } else {
                LOGGER.info("create_bunker_identity_complete key_name={} id={} pubkey={}", identity.getKeyName(), identity.getId(), identity.getPublicKey().toHex().substring(0, 16));
            }
        });
    }

    private CompletableFuture<BunkerIdentity> createKeyInBunker(String keyName, String passphrase) {
        LOGGER.debug("bunker_create_key key_name={}", (Object)keyName);
        return this.connectionPort.createKey(keyName, passphrase).exceptionally(ex -> {
            throw new IdentityException("Failed to create key '" + keyName + "' in bunker: " + ex.getMessage() + ". Suggestion: Check bunker connectivity and verify you have permission to create keys.", (Throwable)ex);
        });
    }

    private CompletableFuture<BunkerIdentity> persistIdentity(BunkerIdentity identity) {
        LOGGER.debug("persist_identity id={} key_name={}", (Object)identity.getId(), (Object)identity.getKeyName());
        return ((CompletableFuture)this.identityRepository.save(identity).thenApply(v -> identity)).exceptionally(ex -> {
            LOGGER.warn("persist_identity_failed id={} error={} action=rollback", (Object)identity.getId(), (Object)ex.getMessage());
            this.connectionPort.deleteKey(identity.getKeyName()).exceptionally(deleteEx -> {
                LOGGER.error("rollback_delete_key_failed key_name={} error={}", (Object)identity.getKeyName(), (Object)deleteEx.getMessage());
                return false;
            });
            throw new IdentityException("Failed to persist identity locally: " + ex.getMessage() + ". Suggestion: Check local storage and retry.", (Throwable)ex);
        });
    }

    public record CreateBunkerIdentityResult(boolean success, BunkerIdentity identity, String errorMessage) {
        public static CreateBunkerIdentityResult success(BunkerIdentity identity) {
            Objects.requireNonNull(identity, "Identity cannot be null for success result");
            return new CreateBunkerIdentityResult(true, identity, null);
        }

        public static CreateBunkerIdentityResult failure(String errorMessage) {
            Objects.requireNonNull(errorMessage, "Error message cannot be null for failure result");
            return new CreateBunkerIdentityResult(false, null, errorMessage);
        }
    }
}

