/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.policy;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.BunkerConnectionPort;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.domain.SigningPolicy;

public class AttachPolicyToKeyUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachPolicyToKeyUseCase.class);
    private final PolicyPort policyPort;
    private final BunkerConnectionPort connectionPort;

    public AttachPolicyToKeyUseCase(PolicyPort policyPort, BunkerConnectionPort connectionPort) {
        this.policyPort = Objects.requireNonNull(policyPort, "Policy port cannot be null");
        this.connectionPort = Objects.requireNonNull(connectionPort, "Connection port cannot be null");
    }

    public CompletableFuture<AttachPolicyResult> execute(String policyId, String keyName) {
        Objects.requireNonNull(policyId, "Policy ID cannot be null");
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.info("attach_policy_started policy_id={} key_name={}", (Object)policyId, (Object)keyName);
        return ((CompletableFuture)((CompletableFuture)this.connectionPort.getKey(keyName).thenCompose(optionalIdentity -> {
            if (optionalIdentity.isEmpty()) {
                LOGGER.warn("attach_policy_rejected policy_id={} key_name={} reason=key_not_found", (Object)policyId, (Object)keyName);
                return CompletableFuture.completedFuture(AttachPolicyResult.keyNotFound(policyId, keyName));
            }
            return this.policyPort.getPolicy(policyId).thenCompose(optionalPolicy -> this.handlePolicyLookup(policyId, keyName, (Optional<SigningPolicy>)optionalPolicy));
        })).exceptionally(error -> AttachPolicyResult.failure(policyId, keyName, this.formatErrorMessage("Failed to attach policy to key", (Throwable)error)))).whenComplete((result, error) -> {
            if (error != null) {
                LOGGER.error("attach_policy_failed policy_id={} key_name={} error={}", policyId, keyName, error.getMessage(), error);
            } else if (result.success()) {
                LOGGER.info("attach_policy_complete policy_id={} key_name={}", (Object)policyId, (Object)keyName);
            } else {
                LOGGER.warn("attach_policy_incomplete policy_id={} key_name={} message={}", policyId, keyName, result.message());
            }
        });
    }

    private CompletableFuture<AttachPolicyResult> handlePolicyLookup(String policyId, String keyName, Optional<SigningPolicy> optionalPolicy) {
        if (optionalPolicy.isEmpty()) {
            LOGGER.warn("attach_policy_rejected policy_id={} key_name={} reason=policy_not_found", (Object)policyId, (Object)keyName);
            return CompletableFuture.completedFuture(AttachPolicyResult.policyNotFound(policyId, keyName));
        }
        SigningPolicy policy = optionalPolicy.get();
        if (!policy.isValid()) {
            LOGGER.warn("attach_policy_rejected policy_id={} key_name={} reason=policy_invalid", (Object)policyId, (Object)keyName);
            return CompletableFuture.completedFuture(AttachPolicyResult.policyInvalid(policyId, keyName));
        }
        return ((CompletableFuture)this.policyPort.attachPolicyToKey(policyId, keyName).thenApply(v -> AttachPolicyResult.success(policyId, keyName, policy.getName()))).exceptionally(error -> AttachPolicyResult.failure(policyId, keyName, this.formatErrorMessage("Failed to attach policy to key", (Throwable)error)));
    }

    private String formatErrorMessage(String whatHappened, Throwable error) {
        String cause = error.getCause() != null ? error.getCause().getMessage() : error.getMessage();
        String why = cause == null || cause.isBlank() ? "Unknown error occurred" : cause;
        return whatHappened + ". " + why + ". Suggestion: Check bunker connectivity and retry the attachment.";
    }

    public record AttachPolicyResult(boolean success, String policyId, String keyName, String policyName, String message) {
        public static AttachPolicyResult success(String policyId, String keyName, String policyName) {
            return new AttachPolicyResult(true, policyId, keyName, policyName, "Policy '" + policyId + "' attached to key '" + keyName + "'. Suggestion: Issue or refresh access tokens if they should enforce this policy.");
        }

        public static AttachPolicyResult policyNotFound(String policyId, String keyName) {
            return new AttachPolicyResult(false, policyId, keyName, null, "Failed to attach policy to key. Policy not found: " + policyId + ". Suggestion: Verify the policy ID or create the policy first.");
        }

        public static AttachPolicyResult keyNotFound(String policyId, String keyName) {
            return new AttachPolicyResult(false, policyId, keyName, null, "Failed to attach policy to key. Identity not found: " + keyName + ". Suggestion: Create the bunker key or confirm the key name.");
        }

        public static AttachPolicyResult policyInvalid(String policyId, String keyName) {
            return new AttachPolicyResult(false, policyId, keyName, null, "Failed to attach policy to key. Policy is inactive or expired. Suggestion: Activate the policy or create a new one before attaching.");
        }

        public static AttachPolicyResult failure(String policyId, String keyName, String message) {
            return new AttachPolicyResult(false, policyId, keyName, null, message);
        }

        public boolean isPolicyNotFound() {
            return !this.success && this.message != null && this.message.contains("Policy not found");
        }

        public boolean isKeyNotFound() {
            return !this.success && this.message != null && this.message.contains("Identity not found");
        }

        public boolean isPolicyInvalid() {
            return !this.success && this.message != null && this.message.contains("inactive or expired");
        }
    }
}

