/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.token;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.TokenPort;
import xyz.tcheeric.identity.domain.AccessToken;

public class GetTokenStatsUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetTokenStatsUseCase.class);
    private final TokenPort tokenPort;

    public GetTokenStatsUseCase(TokenPort tokenPort) {
        this.tokenPort = Objects.requireNonNull(tokenPort, "Token port cannot be null");
    }

    public CompletableFuture<Optional<DetailedTokenStats>> execute(String tokenId) {
        Objects.requireNonNull(tokenId, "Token ID cannot be null");
        LOGGER.debug("get_token_stats_started token_id={}", (Object)tokenId);
        return ((CompletableFuture)this.tokenPort.getTokenStats(tokenId).thenCombine(this.tokenPort.getToken(tokenId), (statsOpt, tokenOpt) -> {
            if (statsOpt.isEmpty() || tokenOpt.isEmpty()) {
                return Optional.empty();
            }
            TokenPort.TokenStats stats = (TokenPort.TokenStats)statsOpt.get();
            AccessToken token = (AccessToken)tokenOpt.get();
            return Optional.of(new DetailedTokenStats(tokenId, token.getKeyName(), token.getClientName(), stats.usageCount(), stats.lastUsedAt() > 0L ? Instant.ofEpochMilli(stats.lastUsedAt()) : null, stats.remainingUsage(), stats.timeUntilExpiry() != null ? Duration.ofMillis(stats.timeUntilExpiry()) : null, token.isValid(), token.isRevoked(), token.isExpired(), token.isUsageLimitReached()));
        })).whenComplete((stats, error) -> {
            if (error != null) {
                LOGGER.error("get_token_stats_failed token_id={} error={}", tokenId, error.getMessage(), error);
            } else {
                LOGGER.debug("get_token_stats_complete token_id={} found={}", (Object)tokenId, (Object)stats.isPresent());
            }
        });
    }

    public CompletableFuture<TokenValiditySummary> getValiditySummary(String tokenId) {
        Objects.requireNonNull(tokenId, "Token ID cannot be null");
        LOGGER.debug("get_validity_summary_started token_id={}", (Object)tokenId);
        return ((CompletableFuture)this.tokenPort.getToken(tokenId).thenApply(tokenOpt -> {
            if (tokenOpt.isEmpty()) {
                return TokenValiditySummary.notFound(tokenId);
            }
            AccessToken token = (AccessToken)tokenOpt.get();
            if (token.isRevoked()) {
                return TokenValiditySummary.revoked(tokenId);
            }
            if (token.isExpired()) {
                return TokenValiditySummary.expired(tokenId);
            }
            if (token.isUsageLimitReached()) {
                return TokenValiditySummary.usageLimitReached(tokenId);
            }
            if (token.isValid()) {
                return TokenValiditySummary.valid(tokenId, token.getTimeUntilExpiration().orElse(null), token.getRemainingUsage().orElse(null));
            }
            return TokenValiditySummary.invalid(tokenId, "Unknown invalid state");
        })).whenComplete((summary, error) -> {
            if (error != null) {
                LOGGER.error("get_validity_summary_failed token_id={} error={}", tokenId, error.getMessage(), error);
            } else {
                LOGGER.debug("get_validity_summary_complete token_id={} status={}", (Object)tokenId, (Object)summary.status());
            }
        });
    }

    public CompletableFuture<Boolean> isExpiringSoon(String tokenId, Duration warningThreshold) {
        Objects.requireNonNull(tokenId, "Token ID cannot be null");
        Objects.requireNonNull(warningThreshold, "Warning threshold cannot be null");
        return this.tokenPort.getTokenStats(tokenId).thenApply(statsOpt -> {
            if (statsOpt.isEmpty()) {
                return false;
            }
            TokenPort.TokenStats stats = (TokenPort.TokenStats)statsOpt.get();
            if (stats.timeUntilExpiry() == null) {
                return false;
            }
            return stats.timeUntilExpiry() <= warningThreshold.toMillis();
        });
    }

    public CompletableFuture<Boolean> isUsageRunningLow(String tokenId, long usageWarningThreshold) {
        Objects.requireNonNull(tokenId, "Token ID cannot be null");
        if (usageWarningThreshold < 0L) {
            throw new IllegalArgumentException("Usage warning threshold cannot be negative");
        }
        return this.tokenPort.getTokenStats(tokenId).thenApply(statsOpt -> {
            if (statsOpt.isEmpty()) {
                return false;
            }
            TokenPort.TokenStats stats = (TokenPort.TokenStats)statsOpt.get();
            if (stats.remainingUsage() == null) {
                return false;
            }
            return stats.remainingUsage() <= usageWarningThreshold;
        });
    }

    public record TokenValiditySummary(String tokenId, TokenStatus status, String statusMessage, Duration timeUntilExpiry, Long remainingUsage) {
        public static TokenValiditySummary valid(String tokenId, Duration timeUntilExpiry, Long remainingUsage) {
            return new TokenValiditySummary(tokenId, TokenStatus.VALID, "Token is valid", timeUntilExpiry, remainingUsage);
        }

        public static TokenValiditySummary revoked(String tokenId) {
            return new TokenValiditySummary(tokenId, TokenStatus.REVOKED, "Token has been revoked", null, null);
        }

        public static TokenValiditySummary expired(String tokenId) {
            return new TokenValiditySummary(tokenId, TokenStatus.EXPIRED, "Token has expired", Duration.ZERO, null);
        }

        public static TokenValiditySummary usageLimitReached(String tokenId) {
            return new TokenValiditySummary(tokenId, TokenStatus.USAGE_LIMIT_REACHED, "Token usage limit has been reached", null, 0L);
        }

        public static TokenValiditySummary invalid(String tokenId, String reason) {
            return new TokenValiditySummary(tokenId, TokenStatus.INVALID, reason, null, null);
        }

        public static TokenValiditySummary notFound(String tokenId) {
            return new TokenValiditySummary(tokenId, TokenStatus.NOT_FOUND, "Token not found", null, null);
        }

        public boolean isValid() {
            return this.status == TokenStatus.VALID;
        }

        public static enum TokenStatus {
            VALID,
            REVOKED,
            EXPIRED,
            USAGE_LIMIT_REACHED,
            INVALID,
            NOT_FOUND;

        }
    }

    public record DetailedTokenStats(String tokenId, String keyName, String clientName, long usageCount, Instant lastUsedAt, Long remainingUsage, Duration timeUntilExpiry, boolean isValid, boolean isRevoked, boolean isExpired, boolean isUsageLimitReached) {
        public String getStatusDescription() {
            if (this.isRevoked) {
                return "Revoked";
            }
            if (this.isExpired) {
                return "Expired";
            }
            if (this.isUsageLimitReached) {
                return "Usage limit reached";
            }
            if (this.isValid) {
                return "Valid";
            }
            return "Invalid";
        }

        public boolean needsAttention(Duration expiryWarning, long usageWarning) {
            if (this.timeUntilExpiry != null && this.timeUntilExpiry.compareTo(expiryWarning) <= 0) {
                return true;
            }
            return this.remainingUsage != null && this.remainingUsage <= usageWarning;
        }
    }
}

