/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.ports.BunkerConnectionPort;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.api.ports.TokenPort;
import xyz.tcheeric.identity.application.usecases.policy.AttachPolicyToKeyUseCase;
import xyz.tcheeric.identity.application.usecases.policy.CreatePolicyUseCase;
import xyz.tcheeric.identity.application.usecases.policy.DeletePolicyUseCase;
import xyz.tcheeric.identity.application.usecases.policy.ListPoliciesUseCase;
import xyz.tcheeric.identity.application.usecases.policy.UpdatePolicyUseCase;
import xyz.tcheeric.identity.application.usecases.token.CreateAccessTokenUseCase;
import xyz.tcheeric.identity.application.usecases.token.GetTokenStatsUseCase;
import xyz.tcheeric.identity.application.usecases.token.ListAccessTokensUseCase;
import xyz.tcheeric.identity.application.usecases.token.RevokeAccessTokenUseCase;
import xyz.tcheeric.identity.cli.IdentityMain;
import xyz.tcheeric.identity.infrastructure.bunker.BunkerConnectionManager;
import xyz.tcheeric.identity.infrastructure.bunker.BunkerPolicyAdapter;
import xyz.tcheeric.identity.infrastructure.bunker.BunkerTokenAdapter;
import xyz.tcheeric.nsecbunker.admin.NsecBunkerAdminClient;

public class IdentityCliConfiguration
implements CommandLine.IFactory,
AutoCloseable {
    private static final String CONFIG_FILE_NAME = "bunker.properties";
    private static final String DEFAULT_STORAGE_DIR = System.getProperty("user.home") + "/.cashu/identities";
    private final CommandLine.IFactory defaultFactory = CommandLine.defaultFactory();
    private final String storageDir;
    private BunkerConnectionManager connectionManager;
    private Supplier<NsecBunkerAdminClient> adminClientSupplier;
    private PolicyPort policyPort;
    private TokenPort tokenPort;
    private CreatePolicyUseCase createPolicyUseCase;
    private UpdatePolicyUseCase updatePolicyUseCase;
    private DeletePolicyUseCase deletePolicyUseCase;
    private ListPoliciesUseCase listPoliciesUseCase;
    private AttachPolicyToKeyUseCase attachPolicyToKeyUseCase;
    private CreateAccessTokenUseCase createAccessTokenUseCase;
    private RevokeAccessTokenUseCase revokeAccessTokenUseCase;
    private ListAccessTokensUseCase listAccessTokensUseCase;
    private GetTokenStatsUseCase getTokenStatsUseCase;

    public IdentityCliConfiguration(String storageDir) {
        this.storageDir = Objects.requireNonNull(storageDir, "Storage directory cannot be null");
    }

    public static IdentityCliConfiguration fromDefaults() {
        String dir = System.getenv("IDENTITY_STORAGE_DIR");
        if (dir == null || dir.isBlank()) {
            dir = DEFAULT_STORAGE_DIR;
        }
        return new IdentityCliConfiguration(dir);
    }

    public CommandLine commandLine() {
        CommandLine cmd = new CommandLine(new IdentityMain(), this);
        cmd.setExecutionExceptionHandler((ex, commandLine, parseResult) -> {
            commandLine.getErr().println("Error: " + ex.getMessage());
            return 2;
        });
        return cmd;
    }

    @Override
    public <K> K create(Class<K> targetClass) throws Exception {
        if (this.hasConstructor(targetClass, CreatePolicyUseCase.class)) {
            return targetClass.getDeclaredConstructor(CreatePolicyUseCase.class).newInstance(this.ensureCreatePolicyUseCase());
        }
        if (this.hasConstructor(targetClass, UpdatePolicyUseCase.class)) {
            return targetClass.getDeclaredConstructor(UpdatePolicyUseCase.class).newInstance(this.ensureUpdatePolicyUseCase());
        }
        if (this.hasConstructor(targetClass, DeletePolicyUseCase.class)) {
            return targetClass.getDeclaredConstructor(DeletePolicyUseCase.class).newInstance(this.ensureDeletePolicyUseCase());
        }
        if (this.hasConstructor(targetClass, ListPoliciesUseCase.class)) {
            return targetClass.getDeclaredConstructor(ListPoliciesUseCase.class).newInstance(this.ensureListPoliciesUseCase());
        }
        if (this.hasConstructor(targetClass, AttachPolicyToKeyUseCase.class)) {
            return targetClass.getDeclaredConstructor(AttachPolicyToKeyUseCase.class).newInstance(this.ensureAttachPolicyToKeyUseCase());
        }
        if (this.hasConstructor(targetClass, CreateAccessTokenUseCase.class)) {
            return targetClass.getDeclaredConstructor(CreateAccessTokenUseCase.class).newInstance(this.ensureCreateAccessTokenUseCase());
        }
        if (this.hasConstructor(targetClass, RevokeAccessTokenUseCase.class)) {
            return targetClass.getDeclaredConstructor(RevokeAccessTokenUseCase.class).newInstance(this.ensureRevokeAccessTokenUseCase());
        }
        if (this.hasConstructor(targetClass, ListAccessTokensUseCase.class)) {
            return targetClass.getDeclaredConstructor(ListAccessTokensUseCase.class).newInstance(this.ensureListAccessTokensUseCase());
        }
        if (this.hasConstructor(targetClass, GetTokenStatsUseCase.class)) {
            return targetClass.getDeclaredConstructor(GetTokenStatsUseCase.class).newInstance(this.ensureGetTokenStatsUseCase());
        }
        if (this.hasConstructor(targetClass, PolicyPort.class)) {
            return targetClass.getDeclaredConstructor(PolicyPort.class).newInstance(this.ensurePolicyPort());
        }
        if (this.hasConstructor(targetClass, TokenPort.class)) {
            return targetClass.getDeclaredConstructor(TokenPort.class).newInstance(this.ensureTokenPort());
        }
        if (this.hasConstructor(targetClass, BunkerConnectionPort.class)) {
            return targetClass.getDeclaredConstructor(BunkerConnectionPort.class).newInstance(this.ensureConnectionManager());
        }
        return this.defaultFactory.create(targetClass);
    }

    private BunkerConnectionManager ensureConnectionManager() {
        if (this.connectionManager == null) {
            BunkerConfig config = this.loadBunkerConfig();
            if (config == null) {
                throw new IllegalStateException("Bunker not configured. Run 'identity bunker configure' first to set up bunker connection.");
            }
            this.connectionManager = new BunkerConnectionManager(config.bunkerPubkey(), config.adminPrivateKey(), config.relays());
        }
        return this.connectionManager;
    }

    private BunkerConfig loadBunkerConfig() {
        try {
            Path configFile = Paths.get(this.storageDir, new String[0]).resolve(CONFIG_FILE_NAME);
            if (!Files.exists(configFile, new LinkOption[0])) {
                return null;
            }
            Properties config = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                config.load(reader);
            }
            String bunkerPubkey = config.getProperty("bunker.pubkey");
            String adminPrivateKey = config.getProperty("admin.privatekey");
            String relaysStr = config.getProperty("bunker.relays", "");
            if (bunkerPubkey == null || bunkerPubkey.isBlank() || adminPrivateKey == null || adminPrivateKey.isBlank()) {
                return null;
            }
            List<String> relays = Arrays.stream(relaysStr.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList();
            if (relays.isEmpty()) {
                relays = List.of("wss://relay.nsec.app");
            }
            return new BunkerConfig(bunkerPubkey, adminPrivateKey, relays);
        }
        catch (Exception e) {
            return null;
        }
    }

    private PolicyPort ensurePolicyPort() {
        if (this.policyPort == null) {
            this.policyPort = new BunkerPolicyAdapter(this.getAdminClientSupplier());
        }
        return this.policyPort;
    }

    private TokenPort ensureTokenPort() {
        if (this.tokenPort == null) {
            this.tokenPort = new BunkerTokenAdapter(this.getAdminClientSupplier());
        }
        return this.tokenPort;
    }

    private CreatePolicyUseCase ensureCreatePolicyUseCase() {
        if (this.createPolicyUseCase == null) {
            this.createPolicyUseCase = new CreatePolicyUseCase(this.ensurePolicyPort());
        }
        return this.createPolicyUseCase;
    }

    private UpdatePolicyUseCase ensureUpdatePolicyUseCase() {
        if (this.updatePolicyUseCase == null) {
            this.updatePolicyUseCase = new UpdatePolicyUseCase(this.ensurePolicyPort());
        }
        return this.updatePolicyUseCase;
    }

    private DeletePolicyUseCase ensureDeletePolicyUseCase() {
        if (this.deletePolicyUseCase == null) {
            this.deletePolicyUseCase = new DeletePolicyUseCase(this.ensurePolicyPort());
        }
        return this.deletePolicyUseCase;
    }

    private ListPoliciesUseCase ensureListPoliciesUseCase() {
        if (this.listPoliciesUseCase == null) {
            this.listPoliciesUseCase = new ListPoliciesUseCase(this.ensurePolicyPort());
        }
        return this.listPoliciesUseCase;
    }

    private AttachPolicyToKeyUseCase ensureAttachPolicyToKeyUseCase() {
        if (this.attachPolicyToKeyUseCase == null) {
            this.attachPolicyToKeyUseCase = new AttachPolicyToKeyUseCase(this.ensurePolicyPort(), this.ensureConnectionManager());
        }
        return this.attachPolicyToKeyUseCase;
    }

    private CreateAccessTokenUseCase ensureCreateAccessTokenUseCase() {
        if (this.createAccessTokenUseCase == null) {
            this.createAccessTokenUseCase = new CreateAccessTokenUseCase(this.ensureTokenPort(), this.ensureConnectionManager(), this.ensurePolicyPort());
        }
        return this.createAccessTokenUseCase;
    }

    private RevokeAccessTokenUseCase ensureRevokeAccessTokenUseCase() {
        if (this.revokeAccessTokenUseCase == null) {
            this.revokeAccessTokenUseCase = new RevokeAccessTokenUseCase(this.ensureTokenPort());
        }
        return this.revokeAccessTokenUseCase;
    }

    private ListAccessTokensUseCase ensureListAccessTokensUseCase() {
        if (this.listAccessTokensUseCase == null) {
            this.listAccessTokensUseCase = new ListAccessTokensUseCase(this.ensureTokenPort());
        }
        return this.listAccessTokensUseCase;
    }

    private GetTokenStatsUseCase ensureGetTokenStatsUseCase() {
        if (this.getTokenStatsUseCase == null) {
            this.getTokenStatsUseCase = new GetTokenStatsUseCase(this.ensureTokenPort());
        }
        return this.getTokenStatsUseCase;
    }

    private Supplier<NsecBunkerAdminClient> getAdminClientSupplier() {
        if (this.adminClientSupplier == null) {
            this.adminClientSupplier = () -> {
                try {
                    BunkerConnectionManager manager = this.ensureConnectionManager();
                    if (!manager.isConnected()) {
                        manager.connect().join();
                    }
                    return manager.getAdminClient().orElse(null);
                }
                catch (Exception e) {
                    return null;
                }
            };
        }
        return this.adminClientSupplier;
    }

    private NsecBunkerAdminClient getAdminClient() {
        Supplier<NsecBunkerAdminClient> supplier = this.getAdminClientSupplier();
        return supplier != null ? supplier.get() : null;
    }

    private <T> boolean hasConstructor(Class<?> targetClass, Class<T> paramType) {
        try {
            targetClass.getDeclaredConstructor(paramType);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    @Override
    public void close() {
        if (this.connectionManager != null) {
            this.connectionManager.close();
        }
    }

    private record BunkerConfig(String bunkerPubkey, String adminPrivateKey, List<String> relays) {
    }
}

