/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import xyz.tcheeric.identity.cli.IdentityCliConfiguration;
import xyz.tcheeric.identity.cli.commands.DeleteCommand;
import xyz.tcheeric.identity.cli.commands.ExportCommand;
import xyz.tcheeric.identity.cli.commands.GenerateCommand;
import xyz.tcheeric.identity.cli.commands.ImportCommand;
import xyz.tcheeric.identity.cli.commands.ListCommand;
import xyz.tcheeric.identity.cli.commands.SetDefaultCommand;
import xyz.tcheeric.identity.cli.commands.SignCommand;
import xyz.tcheeric.identity.cli.commands.bunker.BunkerCommand;
import xyz.tcheeric.identity.cli.commands.profile.MerchantCommand;
import xyz.tcheeric.identity.cli.commands.profile.ProfileCommand;

@CommandLine.Command(name="identity", mixinStandardHelpOptions=true, version={"identity-cli 1.2.0-SNAPSHOT"}, description={"Nostr identity management CLI. Securely generate, store, and use Nostr identities."}, subcommands={GenerateCommand.class, ListCommand.class, ExportCommand.class, ImportCommand.class, DeleteCommand.class, SetDefaultCommand.class, SignCommand.class, BunkerCommand.class, ProfileCommand.class, MerchantCommand.class, CommandLine.HelpCommand.class})
public class IdentityMain
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityMain.class);
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Enable verbose logging"})
    private boolean verbose;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory (default: ~/.cashu/identities)"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) {
        int exit;
        LOGGER.debug("identity_cli_started args={}", (Object)Arrays.toString(args2));
        try (IdentityCliConfiguration configuration = IdentityCliConfiguration.fromDefaults();){
            exit = configuration.commandLine().execute(args2);
        }
        System.exit(exit);
    }

    private static String extractUserMessage(Exception e) {
        Object message = e.getMessage();
        if (message == null || ((String)message).isBlank()) {
            message = e.getClass().getSimpleName() + " occurred";
        }
        message = ((String)message).replaceAll("\\s+at\\s+[a-zA-Z0-9.$_]+\\([^)]+\\)", "");
        message = ((String)message).replaceAll("Caused by:.*", "");
        return ((String)message).trim();
    }

    @Override
    public Integer call() {
        CommandLine.usage(this, System.out);
        return 0;
    }
}

