/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands;

import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.exceptions.IdentityStorageException;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;
import xyz.tcheeric.identity.storage.file.EncryptedFileStorage;
import xyz.tcheeric.identity.storage.file.IdentityMetadata;
import xyz.tcheeric.identity.storage.file.IdentityMetadataStore;

@CommandLine.Command(name="delete", aliases={"rm", "remove"}, description={"Delete an identity (encrypted key + metadata)"}, mixinStandardHelpOptions=true)
public class DeleteCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Identity name"}, arity="0..1")
    private String name;
    @CommandLine.Option(names={"--id"}, description={"Identity ID (takes precedence over name)"})
    private String identityId;
    @CommandLine.Option(names={"-f", "--force"}, description={"Skip confirmation prompt"})
    private boolean force;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    @Override
    public Integer call() {
        try {
            IdentityMetadataStore metadataStore = new IdentityMetadataStore(Paths.get(this.storageDir, new String[0]));
            IdentityMetadata identity = this.findIdentity(metadataStore);
            if (identity == null) {
                return 1;
            }
            if (!this.force) {
                System.out.println("You are about to delete this identity:");
                System.out.println("  Name:       " + identity.getName());
                System.out.println("  ID:         " + identity.getIdentityId());
                System.out.println("  Public Key: " + identity.getPublicKey());
                System.out.println();
                System.out.println("\u26a0 WARNING: This will permanently delete:");
                System.out.println("  - Encrypted private key");
                System.out.println("  - Identity metadata");
                System.out.println();
                System.out.println("  This action CANNOT be undone!");
                System.out.println();
                boolean confirm = PasswordPrompt.promptForConfirmation("Are you sure you want to delete this identity?", false);
                if (!confirm) {
                    System.out.println("Deletion cancelled.");
                    return 0;
                }
            }
            char[] dummyPassword = "dummy".toCharArray();
            try {
                EncryptedFileStorage keyStorage = new EncryptedFileStorage(Paths.get(this.storageDir, "keys"), dummyPassword);
                keyStorage.delete(identity.getIdentityId());
            }
            catch (Exception e) {
                System.err.println("Warning: Could not delete private key file (may not exist): " + e.getMessage());
            }
            metadataStore.delete(identity.getIdentityId());
            System.out.println("\u2713 Identity deleted successfully.");
            System.out.println("  Name: " + identity.getName());
            System.out.println("  ID:   " + identity.getIdentityId());
            return 0;
        }
        catch (IdentityStorageException e) {
            System.err.println("Error deleting identity: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private IdentityMetadata findIdentity(IdentityMetadataStore metadataStore) throws IdentityStorageException {
        if (this.identityId != null && !this.identityId.trim().isEmpty()) {
            IdentityMetadata identity = metadataStore.load(this.identityId.trim());
            if (identity == null) {
                System.err.println("Error: Identity not found with ID: " + this.identityId);
                return null;
            }
            return identity;
        }
        List<IdentityMetadata> allIdentities = metadataStore.listAll();
        if (allIdentities.isEmpty()) {
            System.err.println("Error: No identities found.");
            return null;
        }
        if (this.name != null && !this.name.trim().isEmpty()) {
            String searchName = this.name.trim();
            for (IdentityMetadata identity : allIdentities) {
                if (!identity.getName().equalsIgnoreCase(searchName)) continue;
                return identity;
            }
            System.err.println("Error: Identity not found with name: " + this.name);
            return null;
        }
        System.err.println("Error: Specify which identity to delete:");
        System.err.println("  identity delete \"Name\"");
        System.err.println("  identity delete --id <identity-id>");
        System.err.println();
        System.err.println("Available identities:");
        for (IdentityMetadata identity : allIdentities) {
            System.err.println("  - " + identity.getName() + " (ID: " + identity.getIdentityId() + ")");
        }
        return null;
    }
}

