/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.exceptions.IdentityStorageException;
import xyz.tcheeric.identity.api.exceptions.KeyNotFoundException;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;
import xyz.tcheeric.identity.domain.PrivateKey;
import xyz.tcheeric.identity.storage.file.EncryptedFileStorage;
import xyz.tcheeric.identity.storage.file.IdentityMetadata;
import xyz.tcheeric.identity.storage.file.IdentityMetadataStore;

@CommandLine.Command(name="export", description={"Export identity keys (npub/nsec)"}, mixinStandardHelpOptions=true)
public class ExportCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Identity name (optional if only one identity exists)"}, arity="0..1")
    private String name;
    @CommandLine.Option(names={"--id"}, description={"Identity ID (takes precedence over name)"})
    private String identityId;
    @CommandLine.Option(names={"-p", "--private"}, description={"Export private key (nsec) - KEEP SECRET!"})
    private boolean exportPrivate;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() {
        try {
            IdentityMetadataStore metadataStore = new IdentityMetadataStore(Paths.get(this.storageDir, new String[0]));
            IdentityMetadata identity = this.findIdentity(metadataStore);
            if (identity == null) {
                return 1;
            }
            System.out.println("Identity: " + identity.getName());
            System.out.println("Public Key (npub - safe to share):");
            System.out.println("  " + identity.getPublicKey());
            if (!this.exportPrivate) return 0;
            System.out.println();
            System.out.println("\u26a0 WARNING: You are about to export your PRIVATE KEY!");
            System.out.println("  Never share your private key (nsec) with anyone.");
            System.out.println("  Anyone with your private key can control this identity.");
            System.out.println();
            boolean confirm = PasswordPrompt.promptForConfirmation("Do you really want to export the private key?", false);
            if (!confirm) {
                System.out.println("Export cancelled.");
                return 0;
            }
            char[] password = PasswordPrompt.promptForPassword("Enter password: ");
            try {
                EncryptedFileStorage keyStorage = new EncryptedFileStorage(Paths.get(this.storageDir, "keys"), password);
                PrivateKey domainPrivateKey = keyStorage.load(identity.getIdentityId());
                nostr.base.PrivateKey nostrPrivateKey = domainPrivateKey.toNostrJava();
                String nsec = nostrPrivateKey.toBech32String();
                System.out.println();
                System.out.println("Private Key (nsec - KEEP SECRET!):");
                System.out.println("  " + nsec);
                System.out.println();
                System.out.println("\u26a0 Store this private key securely (password manager, encrypted backup).");
                return 0;
            }
            catch (KeyNotFoundException e) {
                System.err.println("Error: Private key not found for this identity.");
                Integer n = 1;
                return n;
            }
            catch (IdentityStorageException e) {
                System.err.println("Error: Failed to decrypt private key. Wrong password?");
                Integer n = 1;
                return n;
            }
            finally {
                Arrays.fill(password, '\u0000');
            }
        }
        catch (IdentityStorageException e2) {
            System.err.println("Error loading identities: " + e2.getMessage());
            return 1;
        }
        catch (Exception e3) {
            System.err.println("Unexpected error: " + e3.getMessage());
            e3.printStackTrace();
            return 1;
        }
    }

    private IdentityMetadata findIdentity(IdentityMetadataStore metadataStore) throws IdentityStorageException {
        if (this.identityId != null && !this.identityId.trim().isEmpty()) {
            IdentityMetadata identity = metadataStore.load(this.identityId.trim());
            if (identity == null) {
                System.err.println("Error: Identity not found with ID: " + this.identityId);
                return null;
            }
            return identity;
        }
        List<IdentityMetadata> allIdentities = metadataStore.listAll();
        if (allIdentities.isEmpty()) {
            System.err.println("Error: No identities found. Create one with 'identity generate'");
            return null;
        }
        if (this.name != null && !this.name.trim().isEmpty()) {
            String searchName = this.name.trim();
            for (IdentityMetadata identity : allIdentities) {
                if (!identity.getName().equalsIgnoreCase(searchName)) continue;
                return identity;
            }
            System.err.println("Error: Identity not found with name: " + this.name);
            return null;
        }
        if (allIdentities.size() == 1) {
            return allIdentities.get(0);
        }
        IdentityMetadata defaultIdentity = metadataStore.getDefault();
        if (defaultIdentity != null) {
            return defaultIdentity;
        }
        System.err.println("Error: Multiple identities exist. Specify which one to export:");
        System.err.println("  identity export \"Name\"");
        System.err.println("  identity export --id <identity-id>");
        System.err.println();
        System.err.println("Available identities:");
        for (IdentityMetadata identity : allIdentities) {
            System.err.println("  - " + identity.getName() + " (ID: " + identity.getIdentityId() + ")");
        }
        return null;
    }
}

