/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands;

import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Callable;
import nostr.base.PrivateKey;
import nostr.base.PublicKey;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.exceptions.IdentityStorageException;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;
import xyz.tcheeric.identity.infrastructure.crypto.KeyGenerator;
import xyz.tcheeric.identity.storage.file.EncryptedFileStorage;
import xyz.tcheeric.identity.storage.file.IdentityMetadata;
import xyz.tcheeric.identity.storage.file.IdentityMetadataStore;

@CommandLine.Command(name="import", description={"Import an existing Nostr identity from private key (nsec)"}, mixinStandardHelpOptions=true)
public class ImportCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Private key in nsec format (bech32)"})
    private String nsecKey;
    @CommandLine.Option(names={"-n", "--name"}, description={"Name/label for the imported identity"})
    private String name;
    @CommandLine.Option(names={"-d", "--set-default"}, description={"Set this identity as the default"})
    private boolean setAsDefault;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        Integer n;
        PrivateKey nostrPrivateKey;
        if (this.nsecKey == null || this.nsecKey.trim().isEmpty()) {
            System.err.println("Error: Private key (nsec) is required");
            return 1;
        }
        if (!this.nsecKey.startsWith("nsec1")) {
            System.err.println("Error: Private key must be in nsec format (bech32)");
            System.err.println("Example: nsec1...");
            return 1;
        }
        try {
            nostrPrivateKey = new PrivateKey(this.nsecKey.trim());
        }
        catch (Exception e) {
            System.err.println("Error: Invalid nsec format: " + e.getMessage());
            return 1;
        }
        PublicKey nostrPublicKey = KeyGenerator.derivePublicKey(nostrPrivateKey);
        String npub = nostrPublicKey.toBech32String();
        if (this.name == null || this.name.trim().isEmpty()) {
            this.name = PasswordPrompt.promptForText("Enter identity name: ");
            if (this.name == null || this.name.trim().isEmpty()) {
                System.err.println("Error: Identity name is required");
                return 1;
            }
        }
        IdentityMetadataStore metadataStore = new IdentityMetadataStore(Paths.get(this.storageDir, new String[0]));
        for (IdentityMetadata existing : metadataStore.listAll()) {
            if (!existing.getPublicKey().equals(npub)) continue;
            System.err.println("Error: An identity with this public key already exists:");
            System.err.println("  Name: " + existing.getName());
            System.err.println("  ID:   " + existing.getIdentityId());
            return 1;
        }
        System.out.println("Choose a password to encrypt your private key:");
        char[] password = PasswordPrompt.promptForNewPassword("Enter password: ");
        try {
            xyz.tcheeric.identity.domain.PrivateKey domainPrivateKey = xyz.tcheeric.identity.domain.PrivateKey.fromNostrJava(nostrPrivateKey);
            xyz.tcheeric.identity.domain.PublicKey domainPublicKey = xyz.tcheeric.identity.domain.PublicKey.fromNostrJava(nostrPublicKey);
            String identityId = UUID.randomUUID().toString();
            EncryptedFileStorage keyStorage = new EncryptedFileStorage(Paths.get(this.storageDir, "keys"), password);
            System.out.println("Encrypting and storing private key...");
            keyStorage.save(identityId, domainPrivateKey);
            IdentityMetadata metadata = new IdentityMetadata(identityId, this.name.trim(), npub, Instant.now(), this.setAsDefault);
            if (this.setAsDefault) {
                metadataStore.setDefault(identityId);
            } else {
                metadataStore.save(metadata);
            }
            System.out.println("\n\u2713 Identity imported successfully!");
            System.out.println("  Name:       " + this.name);
            System.out.println("  ID:         " + identityId);
            System.out.println("  Public Key: " + npub);
            if (this.setAsDefault) {
                System.out.println("  Status:     DEFAULT");
            }
            System.out.println("\nYour private key is encrypted and stored at:");
            System.out.println("  " + this.storageDir + "/keys/" + identityId + ".enc");
            n = 0;
        }
        catch (Throwable throwable) {
            try {
                Arrays.fill(password, '\u0000');
                throw throwable;
            }
            catch (IdentityStorageException e) {
                System.err.println("Error storing identity: " + e.getMessage());
                return 1;
            }
            catch (IllegalStateException e) {
                System.err.println("Error: " + e.getMessage());
                return 1;
            }
            catch (Exception e) {
                System.err.println("Unexpected error: " + e.getMessage());
                e.printStackTrace();
                return 1;
            }
        }
        Arrays.fill(password, '\u0000');
        return n;
    }
}

