/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands;

import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.exceptions.IdentityStorageException;
import xyz.tcheeric.identity.storage.file.IdentityMetadata;
import xyz.tcheeric.identity.storage.file.IdentityMetadataStore;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List all stored identities"}, mixinStandardHelpOptions=true)
public class ListCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Show detailed information"})
    private boolean verbose;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());

    @Override
    public Integer call() {
        try {
            IdentityMetadataStore metadataStore = new IdentityMetadataStore(Paths.get(this.storageDir, new String[0]));
            List<IdentityMetadata> identities = metadataStore.listAll();
            if (identities.isEmpty()) {
                System.out.println("No identities found.");
                System.out.println("\nTo create a new identity, run:");
                System.out.println("  identity generate \"My Identity\"");
                return 0;
            }
            System.out.println("Stored identities (" + identities.size() + "):\n");
            for (IdentityMetadata identity : identities) {
                this.displayIdentity(identity);
            }
            return 0;
        }
        catch (IdentityStorageException e) {
            System.err.println("Error loading identities: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private void displayIdentity(IdentityMetadata identity) {
        String defaultMarker;
        String string = defaultMarker = identity.isDefault() ? " [DEFAULT]" : "";
        if (this.verbose) {
            System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            System.out.println("Name:       " + identity.getName() + defaultMarker);
            System.out.println("ID:         " + identity.getIdentityId());
            System.out.println("Public Key: " + identity.getPublicKey());
            System.out.println("Created:    " + this.formatTimestamp(identity.getCreatedAt()));
            System.out.println();
        } else {
            String name = this.truncate(identity.getName(), 20);
            String npub = this.truncate(identity.getPublicKey(), 40);
            String created = this.formatTimestamp(identity.getCreatedAt());
            System.out.printf("  %s%-22s  %-42s  %s%s%n", identity.isDefault() ? "\u2605 " : "  ", name, npub, created, defaultMarker.isEmpty() ? "" : " [DEFAULT]");
        }
    }

    private String formatTimestamp(Instant instant) {
        return DATE_FORMATTER.format(instant);
    }

    private String truncate(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength - 3) + "...";
    }
}

