/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands;

import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.exceptions.IdentityStorageException;
import xyz.tcheeric.identity.storage.file.IdentityMetadata;
import xyz.tcheeric.identity.storage.file.IdentityMetadataStore;

@CommandLine.Command(name="set-default", aliases={"default"}, description={"Set the default identity"}, mixinStandardHelpOptions=true)
public class SetDefaultCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Identity name"}, arity="0..1")
    private String name;
    @CommandLine.Option(names={"--id"}, description={"Identity ID (takes precedence over name)"})
    private String identityId;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    @Override
    public Integer call() {
        try {
            IdentityMetadataStore metadataStore = new IdentityMetadataStore(Paths.get(this.storageDir, new String[0]));
            IdentityMetadata identity = this.findIdentity(metadataStore);
            if (identity == null) {
                return 1;
            }
            metadataStore.setDefault(identity.getIdentityId());
            System.out.println("\u2713 Default identity set:");
            System.out.println("  Name:       " + identity.getName());
            System.out.println("  ID:         " + identity.getIdentityId());
            System.out.println("  Public Key: " + identity.getPublicKey());
            return 0;
        }
        catch (IdentityStorageException e) {
            System.err.println("Error setting default identity: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private IdentityMetadata findIdentity(IdentityMetadataStore metadataStore) throws IdentityStorageException {
        if (this.identityId != null && !this.identityId.trim().isEmpty()) {
            IdentityMetadata identity = metadataStore.load(this.identityId.trim());
            if (identity == null) {
                System.err.println("Error: Identity not found with ID: " + this.identityId);
                return null;
            }
            return identity;
        }
        List<IdentityMetadata> allIdentities = metadataStore.listAll();
        if (allIdentities.isEmpty()) {
            System.err.println("Error: No identities found. Create one with 'identity generate'");
            return null;
        }
        if (this.name != null && !this.name.trim().isEmpty()) {
            String searchName = this.name.trim();
            for (IdentityMetadata identity : allIdentities) {
                if (!identity.getName().equalsIgnoreCase(searchName)) continue;
                return identity;
            }
            System.err.println("Error: Identity not found with name: " + this.name);
            return null;
        }
        System.err.println("Error: Specify which identity to set as default:");
        System.err.println("  identity set-default \"Name\"");
        System.err.println("  identity set-default --id <identity-id>");
        System.err.println();
        System.err.println("Available identities:");
        for (IdentityMetadata identity : allIdentities) {
            System.err.println("  - " + identity.getName() + " (ID: " + identity.getIdentityId() + ")");
        }
        return null;
    }
}

