/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.exceptions.IdentityStorageException;
import xyz.tcheeric.identity.storage.file.IdentityMetadata;
import xyz.tcheeric.identity.storage.file.IdentityMetadataStore;

@CommandLine.Command(name="sign", description={"Prepare and validate Nostr events (signing support planned)"}, mixinStandardHelpOptions=true)
public class SignCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Path to event JSON file (or read from stdin if not provided)"}, arity="0..1")
    private String eventFile;
    @CommandLine.Option(names={"-i", "--identity"}, description={"Identity name to use for the event"})
    private String identityName;
    @CommandLine.Option(names={"--id"}, description={"Identity ID (takes precedence over name)"})
    private String identityId;
    @CommandLine.Option(names={"-o", "--output"}, description={"Output file (default: stdout)"})
    private String outputFile;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Integer call() {
        System.err.println("\u26a0 NOTE: SignCommand is currently a preview feature.");
        System.err.println("Full cryptographic signing support is planned for a future release.");
        System.err.println("This command validates event structure and associates it with an identity.");
        System.err.println();
        try {
            String eventJson;
            if (this.eventFile != null) {
                Path path = Paths.get(this.eventFile, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    System.err.println("Error: File not found: " + this.eventFile);
                    return 1;
                }
                eventJson = Files.readString(path);
            } else {
                eventJson = new String(System.in.readAllBytes());
            }
            if (eventJson == null || eventJson.trim().isEmpty()) {
                System.err.println("Error: No event data provided");
                return 1;
            }
            JsonNode eventNode = this.objectMapper.readTree(eventJson);
            if (!eventNode.has("kind")) {
                System.err.println("Error: Event must have 'kind' field");
                return 1;
            }
            if (!eventNode.has("content")) {
                System.err.println("Error: Event must have 'content' field");
                return 1;
            }
            IdentityMetadataStore metadataStore = new IdentityMetadataStore(Paths.get(this.storageDir, new String[0]));
            IdentityMetadata identity = this.findIdentity(metadataStore);
            if (identity == null) {
                return 1;
            }
            StringBuilder output = new StringBuilder();
            output.append("Event prepared for signing:\n\n");
            output.append("Identity:\n");
            output.append("  Name:       ").append(identity.getName()).append("\n");
            output.append("  Public Key: ").append(identity.getPublicKey()).append("\n");
            output.append("\n");
            output.append("Event Details:\n");
            output.append("  Kind:    ").append(eventNode.get("kind").asInt()).append("\n");
            output.append("  Content: ").append(this.truncate(eventNode.get("content").asText(), 50)).append("\n");
            if (eventNode.has("tags")) {
                output.append("  Tags:    ").append(eventNode.get("tags").size()).append(" tag(s)\n");
            }
            output.append("\n");
            output.append("To sign this event, you can:\n");
            output.append("1. Use a Nostr client that supports event signing\n");
            output.append("2. Export your private key: identity export --private\n");
            output.append("3. Import into a signing tool\n");
            if (this.outputFile != null) {
                Files.writeString(Paths.get(this.outputFile, new String[0]), (CharSequence)output.toString(), new OpenOption[0]);
                System.err.println("\u2713 Event information written to: " + this.outputFile);
            } else {
                System.out.println(output.toString());
            }
            return 0;
        }
        catch (IdentityStorageException e) {
            System.err.println("Error loading identities: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private IdentityMetadata findIdentity(IdentityMetadataStore metadataStore) throws IdentityStorageException {
        if (this.identityId != null && !this.identityId.trim().isEmpty()) {
            IdentityMetadata identity = metadataStore.load(this.identityId.trim());
            if (identity == null) {
                System.err.println("Error: Identity not found with ID: " + this.identityId);
                return null;
            }
            return identity;
        }
        List<IdentityMetadata> allIdentities = metadataStore.listAll();
        if (allIdentities.isEmpty()) {
            System.err.println("Error: No identities found. Create one with 'identity generate'");
            return null;
        }
        if (this.identityName != null && !this.identityName.trim().isEmpty()) {
            String searchName = this.identityName.trim();
            for (IdentityMetadata identity : allIdentities) {
                if (!identity.getName().equalsIgnoreCase(searchName)) continue;
                return identity;
            }
            System.err.println("Error: Identity not found with name: " + this.identityName);
            return null;
        }
        if (allIdentities.size() == 1) {
            return allIdentities.get(0);
        }
        IdentityMetadata defaultIdentity = metadataStore.getDefault();
        if (defaultIdentity != null) {
            return defaultIdentity;
        }
        System.err.println("Error: Multiple identities exist. Specify which one to use:");
        System.err.println("  identity sign --identity \"Name\" event.json");
        System.err.println("  identity sign --id <identity-id> event.json");
        return null;
    }

    private String truncate(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength - 3) + "...";
    }
}

