/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;

@CommandLine.Command(name="configure", aliases={"config", "setup"}, description={"Configure nsecBunker connection settings"}, mixinStandardHelpOptions=true)
public class BunkerConfigureCommand
implements Callable<Integer> {
    private static final String CONFIG_FILE_NAME = "bunker.properties";
    @CommandLine.Parameters(index="0", description={"Bunker URI (bunker://pubkey?relay=... or nostr+bunker://...)"}, arity="0..1")
    private String bunkerUri;
    @CommandLine.Option(names={"-r", "--relay"}, description={"Relay URL for bunker communication (can be specified multiple times)"}, split=",")
    private String[] relays;
    @CommandLine.Option(names={"--bunker-pubkey"}, description={"Bunker public key (hex or npub format)"})
    private String bunkerPubkey;
    @CommandLine.Option(names={"--client-key"}, description={"Client private key for bunker authentication (hex or nsec format)"})
    private String clientKey;
    @CommandLine.Option(names={"--generate-client-key"}, description={"Generate a new client private key for bunker authentication"})
    private boolean generateClientKey;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    @Override
    public Integer call() {
        try {
            if (this.bunkerUri == null && this.bunkerPubkey == null) {
                System.out.println("Enter bunker connection details:");
                this.bunkerUri = PasswordPrompt.promptForText("Bunker URI (or press enter to skip): ");
                if (this.bunkerUri == null || this.bunkerUri.trim().isEmpty()) {
                    this.bunkerPubkey = PasswordPrompt.promptForText("Bunker public key (npub or hex): ");
                    if (this.bunkerPubkey == null || this.bunkerPubkey.trim().isEmpty()) {
                        System.err.println("Error: Either bunker URI or bunker public key is required");
                        return 1;
                    }
                    String relayInput = PasswordPrompt.promptForText("Relay URL: ");
                    if (relayInput != null && !relayInput.trim().isEmpty()) {
                        this.relays = relayInput.split(",");
                    }
                }
            }
            Properties config = new Properties();
            if (this.bunkerUri != null && !this.bunkerUri.trim().isEmpty()) {
                BunkerUriComponents parsed = this.parseBunkerUri(this.bunkerUri.trim());
                if (parsed == null) {
                    System.err.println("Error: Invalid bunker URI format");
                    System.err.println("Expected format: bunker://pubkey?relay=wss://...");
                    return 1;
                }
                config.setProperty("bunker.pubkey", parsed.pubkey);
                if (parsed.relay != null) {
                    config.setProperty("bunker.relays", parsed.relay);
                }
                if (parsed.secret != null) {
                    config.setProperty("bunker.secret", parsed.secret);
                }
            } else {
                config.setProperty("bunker.pubkey", this.bunkerPubkey.trim());
            }
            if (this.relays != null && this.relays.length > 0) {
                config.setProperty("bunker.relays", String.join((CharSequence)",", this.relays));
            }
            if (this.generateClientKey) {
                byte[] keyBytes = new byte[32];
                new SecureRandom().nextBytes(keyBytes);
                StringBuilder hexKey = new StringBuilder();
                for (byte b : keyBytes) {
                    hexKey.append(String.format("%02x", b));
                }
                this.clientKey = hexKey.toString();
                System.out.println("Generated client key: " + this.clientKey.substring(0, 16) + "...");
            } else if (this.clientKey == null) {
                String input = PasswordPrompt.promptForText("Client private key (or press enter to generate): ");
                if (input != null && !input.trim().isEmpty()) {
                    this.clientKey = input.trim();
                } else {
                    byte[] keyBytes = new byte[32];
                    new SecureRandom().nextBytes(keyBytes);
                    StringBuilder hexKey = new StringBuilder();
                    for (byte b : keyBytes) {
                        hexKey.append(String.format("%02x", b));
                    }
                    this.clientKey = hexKey.toString();
                    System.out.println("Generated client key: " + this.clientKey.substring(0, 16) + "...");
                }
            }
            if (this.clientKey != null && !this.clientKey.trim().isEmpty()) {
                config.setProperty("bunker.client.key", this.clientKey.trim());
            }
            if (!config.containsKey("bunker.pubkey")) {
                System.err.println("Error: Bunker public key is required");
                return 1;
            }
            if (!config.containsKey("bunker.relays")) {
                System.err.println("Error: At least one relay URL is required");
                return 1;
            }
            Path configDir = Paths.get(this.storageDir, new String[0]);
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path configFile = configDir.resolve(CONFIG_FILE_NAME);
            try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                config.store(writer, "nsecBunker configuration");
            }
            System.out.println("\n\u2713 Bunker configuration saved!");
            System.out.println("  Bunker:  " + config.getProperty("bunker.pubkey"));
            System.out.println("  Relays:  " + config.getProperty("bunker.relays"));
            System.out.println("  Config:  " + String.valueOf(configFile));
            System.out.println("\nTo test the connection, run:");
            System.out.println("  identity bunker status");
            return 0;
        }
        catch (IOException e) {
            System.err.println("Error saving configuration: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private BunkerUriComponents parseBunkerUri(String uri) {
        String pubkey;
        String normalized = uri;
        if (uri.startsWith("nostr+bunker://")) {
            normalized = uri.substring("nostr+".length());
        }
        if (!normalized.startsWith("bunker://")) {
            return null;
        }
        String rest = normalized.substring("bunker://".length());
        String relay = null;
        String secret = null;
        int queryStart = rest.indexOf(63);
        if (queryStart > 0) {
            pubkey = rest.substring(0, queryStart);
            String query = rest.substring(queryStart + 1);
            block8: for (String param : query.split("&")) {
                String[] kv = param.split("=", 2);
                if (kv.length != 2) continue;
                switch (kv[0].toLowerCase()) {
                    case "relay": {
                        relay = URLDecoder.decode(kv[1], StandardCharsets.UTF_8);
                        continue block8;
                    }
                    case "secret": {
                        secret = kv[1];
                    }
                }
            }
        } else {
            pubkey = rest;
        }
        if (pubkey.isEmpty()) {
            return null;
        }
        return new BunkerUriComponents(pubkey, relay, secret);
    }

    private record BunkerUriComponents(String pubkey, String relay, String secret) {
    }
}

