/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;

@CommandLine.Command(name="create", description={"Create a new identity in nsecBunker"}, mixinStandardHelpOptions=true)
public class BunkerCreateCommand
implements Callable<Integer> {
    private static final String CONFIG_FILE_NAME = "bunker.properties";
    @CommandLine.Parameters(index="0", description={"Name/label for the identity"}, arity="0..1")
    private String keyName;
    @CommandLine.Option(names={"-p", "--passphrase"}, description={"Encrypt the key in the bunker with a passphrase"})
    private boolean usePassphrase;
    @CommandLine.Option(names={"-d", "--set-default"}, description={"Set this identity as the default"})
    private boolean setAsDefault;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    @Override
    public Integer call() {
        try {
            Path configFile = Paths.get(this.storageDir, new String[0]).resolve(CONFIG_FILE_NAME);
            if (!Files.exists(configFile, new LinkOption[0])) {
                System.err.println("Error: Bunker not configured");
                System.err.println("Run 'identity bunker configure' first");
                return 1;
            }
            Properties config = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                config.load(reader);
            }
            if (this.keyName == null || this.keyName.trim().isEmpty()) {
                this.keyName = PasswordPrompt.promptForText("Enter key name: ");
                if (this.keyName == null || this.keyName.trim().isEmpty()) {
                    System.err.println("Error: Key name is required");
                    return 1;
                }
            }
            String passphrase = null;
            if (this.usePassphrase) {
                System.out.println("Enter a passphrase to encrypt the key in the bunker:");
                char[] passphraseChars = PasswordPrompt.promptForNewPassword("Passphrase: ");
                passphrase = new String(passphraseChars);
                Arrays.fill(passphraseChars, '\u0000');
            }
            System.out.println("\nCreating identity in bunker...");
            System.out.println("  Key Name:   " + this.keyName);
            System.out.println("  Bunker:     " + this.truncatePubkey(config.getProperty("bunker.pubkey")));
            System.out.println("  Relays:     " + config.getProperty("bunker.relays"));
            System.out.println("  Passphrase: " + (passphrase != null ? "yes" : "no"));
            System.out.println("\n[Note: Full bunker integration pending]");
            System.out.println("This command will:");
            System.out.println("  1. Connect to the bunker via relays");
            System.out.println("  2. Request key creation in the bunker");
            System.out.println("  3. Store identity metadata locally");
            System.out.println("  4. Display the new public key (npub)");
            System.out.println("\nTo implement this, the CLI needs to be wired to:");
            System.out.println("  - BunkerConnectionAdapter (infrastructure layer)");
            System.out.println("  - CreateBunkerIdentityUseCase (application layer)");
            return 0;
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (IllegalStateException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null) {
            return "not set";
        }
        if (pubkey.length() <= 20) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }
}

