/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;

@CommandLine.Command(name="disconnect", description={"Disconnect from nsecBunker"}, mixinStandardHelpOptions=true)
public class BunkerDisconnectCommand
implements Callable<Integer> {
    private static final String CONFIG_FILE_NAME = "bunker.properties";
    @CommandLine.Option(names={"--clear-config"}, description={"Remove bunker configuration (requires reconfiguration to reconnect)"})
    private boolean clearConfig;
    @CommandLine.Option(names={"-f", "--force"}, description={"Skip confirmation prompts"})
    private boolean force;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    @Override
    public Integer call() {
        try {
            Path configFile = Paths.get(this.storageDir, new String[0]).resolve(CONFIG_FILE_NAME);
            if (!Files.exists(configFile, new LinkOption[0])) {
                System.out.println("No bunker configuration found.");
                return 0;
            }
            if (this.clearConfig && !this.force) {
                System.out.println("This will remove your bunker configuration.");
                System.out.println("You will need to reconfigure to connect again.");
                System.out.println();
                boolean confirmed = PasswordPrompt.promptForConfirmation("Are you sure you want to clear the configuration?", false);
                if (!confirmed) {
                    System.out.println("Cancelled.");
                    return 0;
                }
            }
            if (this.clearConfig) {
                Files.deleteIfExists(configFile);
                System.out.println("\u2713 Bunker configuration cleared.");
                System.out.println("\nTo reconfigure, run:");
                System.out.println("  identity bunker configure --help");
            } else {
                System.out.println("\u2713 Bunker disconnected.");
                System.out.println("\nConfiguration preserved. To clear it, run:");
                System.out.println("  identity bunker disconnect --clear-config");
            }
            return 0;
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }
}

