/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import picocli.CommandLine;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;

@CommandLine.Command(name="import", description={"Import an existing private key into nsecBunker"}, mixinStandardHelpOptions=true)
public class BunkerImportCommand
implements Callable<Integer> {
    private static final String CONFIG_FILE_NAME = "bunker.properties";
    private static final Pattern NSEC_PATTERN = Pattern.compile("^nsec1[qpzry9x8gf2tvdw0s3jn54khce6mua7l]{58}$");
    private static final Pattern HEX_PATTERN = Pattern.compile("^[0-9a-fA-F]{64}$");
    @CommandLine.Parameters(index="0", description={"Private key to import (nsec or 64-char hex)"}, arity="0..1")
    private String nsec;
    @CommandLine.Option(names={"-n", "--name"}, description={"Name/label for the imported identity"}, required=true)
    private String keyName;
    @CommandLine.Option(names={"-p", "--passphrase"}, description={"Encrypt the key in the bunker with a passphrase"})
    private boolean usePassphrase;
    @CommandLine.Option(names={"-d", "--set-default"}, description={"Set this identity as the default"})
    private boolean setAsDefault;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    @Override
    public Integer call() {
        try {
            Path configFile = Paths.get(this.storageDir, new String[0]).resolve(CONFIG_FILE_NAME);
            if (!Files.exists(configFile, new LinkOption[0])) {
                System.err.println("Error: Bunker not configured");
                System.err.println("Run 'identity bunker configure' first");
                return 1;
            }
            Properties config = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                config.load(reader);
            }
            if (this.nsec == null || this.nsec.trim().isEmpty()) {
                System.out.println("Enter your private key (nsec or hex format):");
                System.out.println("WARNING: Your key will be transmitted to the bunker.");
                char[] nsecChars = PasswordPrompt.promptForPassword("Private key: ");
                this.nsec = new String(nsecChars);
                Arrays.fill(nsecChars, '\u0000');
            }
            if (!this.isValidKeyFormat(this.nsec.trim())) {
                System.err.println("Error: Invalid private key format");
                System.err.println("Expected: nsec1... (bech32) or 64-character hex string");
                return 1;
            }
            String passphrase = null;
            if (this.usePassphrase) {
                System.out.println("Enter a passphrase to encrypt the key in the bunker:");
                char[] passphraseChars = PasswordPrompt.promptForNewPassword("Passphrase: ");
                passphrase = new String(passphraseChars);
                Arrays.fill(passphraseChars, '\u0000');
            }
            System.out.println("\nImporting identity to bunker...");
            System.out.println("  Key Name:   " + this.keyName);
            System.out.println("  Key Format: " + (this.nsec.startsWith("nsec") ? "bech32 (nsec)" : "hex"));
            System.out.println("  Bunker:     " + this.truncatePubkey(config.getProperty("bunker.pubkey")));
            System.out.println("  Passphrase: " + (passphrase != null ? "yes" : "no"));
            System.out.println("\n[Note: Full bunker integration pending]");
            System.out.println("This command will:");
            System.out.println("  1. Connect to the bunker via relays");
            System.out.println("  2. Send the key to the bunker for storage");
            System.out.println("  3. Store identity metadata locally");
            System.out.println("  4. Display the public key (npub)");
            System.out.println("\nTo implement this, the CLI needs to be wired to:");
            System.out.println("  - BunkerConnectionAdapter (infrastructure layer)");
            System.out.println("  - ImportIdentityToBunkerUseCase (application layer)");
            return 0;
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (IllegalStateException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private boolean isValidKeyFormat(String key) {
        return NSEC_PATTERN.matcher(key).matches() || HEX_PATTERN.matcher(key).matches();
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null) {
            return "not set";
        }
        if (pubkey.length() <= 20) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }
}

