/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"Check nsecBunker connection status"}, mixinStandardHelpOptions=true)
public class BunkerStatusCommand
implements Callable<Integer> {
    private static final String CONFIG_FILE_NAME = "bunker.properties";
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Show detailed status information"})
    private boolean verbose;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    @Override
    public Integer call() {
        try {
            Path configFile = Paths.get(this.storageDir, new String[0]).resolve(CONFIG_FILE_NAME);
            System.out.println("nsecBunker Status");
            System.out.println("=================\n");
            if (!Files.exists(configFile, new LinkOption[0])) {
                System.out.println("Status: NOT CONFIGURED");
                System.out.println("\nTo configure bunker connection, run:");
                System.out.println("  identity bunker configure --help");
                return 0;
            }
            Properties config = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                config.load(reader);
            }
            String bunkerPubkey = config.getProperty("bunker.pubkey");
            String relays = config.getProperty("bunker.relays");
            boolean hasClientKey = config.containsKey("bunker.client.key");
            System.out.println("Configuration");
            System.out.println("-------------");
            System.out.println("  Bunker:     " + this.truncatePubkey(bunkerPubkey));
            System.out.println("  Relays:     " + relays);
            System.out.println("  Client Key: " + (hasClientKey ? "configured" : "not configured"));
            System.out.println("  Config:     " + String.valueOf(configFile));
            if (this.verbose) {
                System.out.println("\nFull Configuration:");
                for (String key : config.stringPropertyNames()) {
                    String value = config.getProperty(key);
                    if (key.contains("key") || key.contains("secret")) {
                        value = this.maskSensitiveValue(value);
                    }
                    System.out.println("  " + key + " = " + value);
                }
            }
            System.out.println("\nConnection Status");
            System.out.println("-----------------");
            System.out.println("  Status: CONFIGURED (not connected)");
            System.out.println("\n  Note: Connection is established on-demand when");
            System.out.println("        performing bunker operations.");
            System.out.println("\nTo create a new identity in the bunker:");
            System.out.println("  identity bunker create \"my-key\"");
            System.out.println("\nTo list bunker identities:");
            System.out.println("  identity list --bunker");
            return 0;
        }
        catch (IOException e) {
            System.err.println("Error reading configuration: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null) {
            return "not set";
        }
        if (pubkey.length() <= 20) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }

    private String maskSensitiveValue(String value) {
        if (value == null || value.length() <= 8) {
            return "****";
        }
        return value.substring(0, 4) + "..." + value.substring(value.length() - 4);
    }
}

