/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;

@CommandLine.Command(name="unlock", description={"Unlock a locked identity in nsecBunker"}, mixinStandardHelpOptions=true)
public class BunkerUnlockCommand
implements Callable<Integer> {
    private static final String CONFIG_FILE_NAME = "bunker.properties";
    @CommandLine.Parameters(index="0", description={"Name of the identity to unlock"}, arity="0..1")
    private String keyName;
    @CommandLine.Option(names={"--id"}, description={"Identity ID (alternative to name)"})
    private String identityId;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    @Override
    public Integer call() {
        try {
            String targetIdentity;
            Path configFile = Paths.get(this.storageDir, new String[0]).resolve(CONFIG_FILE_NAME);
            if (!Files.exists(configFile, new LinkOption[0])) {
                System.err.println("Error: Bunker not configured");
                System.err.println("Run 'identity bunker configure' first");
                return 1;
            }
            Properties config = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                config.load(reader);
            }
            if (this.identityId != null && !this.identityId.trim().isEmpty()) {
                targetIdentity = "ID: " + this.identityId;
            } else if (this.keyName != null && !this.keyName.trim().isEmpty()) {
                targetIdentity = "Name: " + this.keyName;
            } else {
                this.keyName = PasswordPrompt.promptForText("Enter identity name to unlock: ");
                if (this.keyName == null || this.keyName.trim().isEmpty()) {
                    System.err.println("Error: Identity name or ID is required");
                    return 1;
                }
                targetIdentity = "Name: " + this.keyName;
            }
            System.out.println("Enter the passphrase to unlock the identity:");
            char[] passphraseChars = PasswordPrompt.promptForPassword("Passphrase: ");
            String passphrase = new String(passphraseChars);
            Arrays.fill(passphraseChars, '\u0000');
            if (passphrase.isEmpty()) {
                System.err.println("Error: Passphrase is required");
                return 1;
            }
            System.out.println("\nUnlocking identity in bunker...");
            System.out.println("  Identity: " + targetIdentity);
            System.out.println("  Bunker:   " + this.truncatePubkey(config.getProperty("bunker.pubkey")));
            System.out.println("\n[Note: Full bunker integration pending]");
            System.out.println("This command will:");
            System.out.println("  1. Connect to the bunker via relays");
            System.out.println("  2. Send unlock request with passphrase");
            System.out.println("  3. Report success or failure");
            System.out.println("\nTo implement this, the CLI needs to be wired to:");
            System.out.println("  - BunkerConnectionAdapter (infrastructure layer)");
            System.out.println("  - BunkerConnectionPort.unlockKey() method");
            return 0;
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (IllegalStateException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Unexpected error: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null) {
            return "not set";
        }
        if (pubkey.length() <= 20) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }
}

