/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.application.usecases.policy.AttachPolicyToKeyUseCase;

@CommandLine.Command(name="attach", description={"Attach a signing policy to a bunker identity"}, mixinStandardHelpOptions=true)
public class PolicyAttachCommand
implements Callable<Integer> {
    private final AttachPolicyToKeyUseCase useCase;
    @CommandLine.Parameters(index="0", description={"Policy ID to attach"}, arity="1")
    private String policyId;
    @CommandLine.Parameters(index="1", description={"Bunker key name to attach the policy to"}, arity="1")
    private String keyName;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    public PolicyAttachCommand() {
        this.useCase = null;
    }

    public PolicyAttachCommand(AttachPolicyToKeyUseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public Integer call() {
        try {
            if (this.useCase == null) {
                System.err.println("Error: Bunker connection not available");
                System.err.println("Run 'identity bunker configure' first to set up bunker connection");
                return 1;
            }
            System.out.println("Attaching policy to bunker key...");
            System.out.println("  Policy: " + this.policyId);
            System.out.println("  Key:    " + this.keyName);
            AttachPolicyToKeyUseCase.AttachPolicyResult result = this.useCase.execute(this.policyId, this.keyName).join();
            if (result.success()) {
                System.out.println();
                System.out.println("Policy attached successfully.");
                System.out.println("  Policy: " + this.policyId + (String)(result.policyName() != null ? " (" + result.policyName() + ")" : ""));
                System.out.println("  Key:    " + this.keyName);
                System.out.println("  Note:   " + result.message());
                return 0;
            }
            System.err.println("Error: " + result.message());
            return 1;
        }
        catch (Exception e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            System.err.println("Error: " + message);
            return 1;
        }
    }
}

