/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picocli.CommandLine;
import xyz.tcheeric.identity.application.usecases.policy.CreatePolicyUseCase;
import xyz.tcheeric.identity.domain.PolicyRule;
import xyz.tcheeric.identity.domain.SigningPolicy;

@CommandLine.Command(name="create", description={"Create a new signing policy"}, mixinStandardHelpOptions=true)
public class PolicyCreateCommand
implements Callable<Integer> {
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(\\d+)([dhms])$", 2);
    private final CreatePolicyUseCase useCase;
    @CommandLine.Parameters(index="0", description={"Policy name"}, arity="1")
    private String policyName;
    @CommandLine.Option(names={"-d", "--description"}, description={"Policy description"})
    private String description;
    @CommandLine.Option(names={"--allow-kind"}, description={"Allow signing events of this kind (can be repeated)"}, arity="0..*")
    private List<Integer> allowKinds = new ArrayList<Integer>();
    @CommandLine.Option(names={"--deny-kind"}, description={"Deny signing events of this kind (can be repeated)"}, arity="0..*")
    private List<Integer> denyKinds = new ArrayList<Integer>();
    @CommandLine.Option(names={"--allow-method"}, description={"Allow this NIP-46 method (can be repeated)"}, arity="0..*")
    private List<String> allowMethods = new ArrayList<String>();
    @CommandLine.Option(names={"--deny-method"}, description={"Deny this NIP-46 method (can be repeated)"}, arity="0..*")
    private List<String> denyMethods = new ArrayList<String>();
    @CommandLine.Option(names={"--expires-in"}, description={"Policy expiration (e.g., '30d' for 30 days, '24h' for 24 hours)"})
    private String expiresIn;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    public PolicyCreateCommand() {
        this.useCase = null;
    }

    public PolicyCreateCommand(CreatePolicyUseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public Integer call() {
        try {
            if (this.policyName == null || this.policyName.trim().isEmpty()) {
                System.err.println("Error: Policy name is required");
                return 1;
            }
            if (this.useCase == null) {
                System.err.println("Error: Bunker connection not available");
                System.err.println("Run 'identity bunker configure' first to set up bunker connection");
                return 1;
            }
            List<PolicyRule> rules = this.buildRules();
            Duration expiration = this.parseExpiration(this.expiresIn);
            System.out.println("Creating policy in bunker...");
            System.out.println("  Name:        " + this.policyName);
            if (this.description != null) {
                System.out.println("  Description: " + this.description);
            }
            if (!rules.isEmpty()) {
                System.out.println("  Rules:       " + rules.size());
            }
            if (expiration != null) {
                System.out.println("  Expires in:  " + this.formatDuration(expiration));
            }
            CreatePolicyUseCase.CreatePolicyRequest request = new CreatePolicyUseCase.CreatePolicyRequest(this.policyName, this.description, rules, expiration);
            SigningPolicy createdPolicy = this.useCase.execute(request).join();
            System.out.println();
            System.out.println("Policy created successfully!");
            System.out.println("\u2550".repeat(50));
            System.out.println("  ID:          " + createdPolicy.getId());
            System.out.println("  Name:        " + createdPolicy.getName());
            if (createdPolicy.getDescription() != null) {
                System.out.println("  Description: " + String.valueOf(createdPolicy.getDescription()));
            }
            System.out.println("  Rules:       " + createdPolicy.getRuleCount());
            System.out.println("  Active:      " + (createdPolicy.isActive() ? "yes" : "no"));
            System.out.println("\u2550".repeat(50));
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            System.err.println("Error: " + message);
            return 1;
        }
    }

    private List<PolicyRule> buildRules() {
        ArrayList<PolicyRule> rules = new ArrayList<PolicyRule>();
        for (Integer kind : this.allowKinds) {
            rules.add(PolicyRule.allowEventKind(kind));
        }
        for (Integer kind : this.denyKinds) {
            rules.add(PolicyRule.denyEventKind(kind));
        }
        for (String method : this.allowMethods) {
            rules.add(PolicyRule.allowMethod(method));
        }
        for (String method : this.denyMethods) {
            rules.add(PolicyRule.denyMethod(method));
        }
        return rules;
    }

    private Duration parseExpiration(String expirationStr) {
        String unit;
        if (expirationStr == null || expirationStr.isBlank()) {
            return null;
        }
        Matcher matcher = DURATION_PATTERN.matcher(expirationStr.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid expiration format: " + expirationStr + ". Use format like '30d' (days), '24h' (hours), '30m' (minutes), or '60s' (seconds)");
        }
        long value = Long.parseLong(matcher.group(1));
        return switch (unit = matcher.group(2).toLowerCase()) {
            case "d" -> Duration.ofDays(value);
            case "h" -> Duration.ofHours(value);
            case "m" -> Duration.ofMinutes(value);
            case "s" -> Duration.ofSeconds(value);
            default -> throw new IllegalArgumentException("Invalid duration unit: " + unit);
        };
    }

    private String formatDuration(Duration duration) {
        if (duration.toDays() > 0L) {
            return duration.toDays() + " day(s)";
        }
        if (duration.toHours() > 0L) {
            return duration.toHours() + " hour(s)";
        }
        if (duration.toMinutes() > 0L) {
            return duration.toMinutes() + " minute(s)";
        }
        return duration.toSeconds() + " second(s)";
    }
}

