/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.application.usecases.policy.DeletePolicyUseCase;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;

@CommandLine.Command(name="delete", description={"Delete a signing policy"}, mixinStandardHelpOptions=true)
public class PolicyDeleteCommand
implements Callable<Integer> {
    private final DeletePolicyUseCase useCase;
    @CommandLine.Parameters(index="0", description={"Policy ID to delete"}, arity="1")
    private String policyId;
    @CommandLine.Option(names={"-f", "--force"}, description={"Skip confirmation prompt"})
    private boolean force;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    public PolicyDeleteCommand() {
        this.useCase = null;
    }

    public PolicyDeleteCommand(DeletePolicyUseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public Integer call() {
        try {
            DeletePolicyUseCase.DeletePolicyResult result;
            if (this.useCase == null) {
                System.err.println("Error: Bunker connection not available");
                System.err.println("Run 'identity bunker configure' first to set up bunker connection");
                return 1;
            }
            System.out.println("Deleting policy from bunker...");
            System.out.println("  Policy ID: " + this.policyId);
            if (!this.force) {
                System.out.println();
                System.out.println("WARNING: This action cannot be undone.");
                System.out.println("Any tokens using this policy will no longer have restrictions.");
                String response = PasswordPrompt.promptForText("Type 'DELETE' to confirm: ");
                if (!"DELETE".equals(response)) {
                    System.out.println("Cancelled.");
                    return 0;
                }
            }
            if ((result = this.useCase.execute(this.policyId).join()).success()) {
                System.out.println();
                System.out.println("Policy deleted successfully.");
                if (result.policyName() != null) {
                    System.out.println("  Deleted: " + result.policyName());
                }
            } else {
                Object errorMsg = result.errorMessage() != null ? result.errorMessage() : "Policy not found or could not be deleted: " + this.policyId;
                System.err.println("Error: " + (String)errorMsg);
                return 1;
            }
            return 0;
        }
        catch (IllegalStateException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            System.err.println("Error: " + message);
            return 1;
        }
    }
}

