/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.application.usecases.policy.ListPoliciesUseCase;
import xyz.tcheeric.identity.domain.SigningPolicy;

@CommandLine.Command(name="list", description={"List all signing policies"}, mixinStandardHelpOptions=true)
public class PolicyListCommand
implements Callable<Integer> {
    private final ListPoliciesUseCase useCase;
    @CommandLine.Option(names={"--active-only"}, description={"Only show active policies"})
    private boolean activeOnly;
    @CommandLine.Option(names={"--valid-only"}, description={"Only show valid policies (active and not expired)"})
    private boolean validOnly;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Show detailed information including rules"})
    private boolean verbose;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    public PolicyListCommand() {
        this.useCase = null;
    }

    public PolicyListCommand(ListPoliciesUseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public Integer call() {
        try {
            if (this.useCase == null) {
                System.err.println("Error: Bunker connection not available");
                System.err.println("Run 'identity bunker configure' first to set up bunker connection");
                return 1;
            }
            System.out.println("Listing policies from bunker...");
            System.out.println("  Filter: " + this.getFilterDescription());
            ListPoliciesUseCase.PolicyFilter filter2 = this.validOnly ? ListPoliciesUseCase.PolicyFilter.onlyValid() : (this.activeOnly ? ListPoliciesUseCase.PolicyFilter.onlyActive() : ListPoliciesUseCase.PolicyFilter.all());
            List<SigningPolicy> policies = this.useCase.execute(filter2).join();
            if (policies.isEmpty()) {
                System.out.println("\nNo policies found.");
                return 0;
            }
            System.out.println();
            System.out.println("\u2500".repeat(70));
            System.out.printf("%-20s %-30s %-10s %-10s%n", "ID", "NAME", "ACTIVE", "RULES");
            System.out.println("\u2500".repeat(70));
            int activeCount = 0;
            for (SigningPolicy policy : policies) {
                boolean isActive = policy.isActive();
                if (isActive) {
                    ++activeCount;
                }
                System.out.printf("%-20s %-30s %-10s %-10s%n", this.truncate(policy.getId(), 20), this.truncate(policy.getName(), 30), isActive ? "yes" : "no", policy.getRuleCount());
                if (!this.verbose) continue;
                if (policy.getDescription() != null) {
                    System.out.println("    Description: " + String.valueOf(policy.getDescription()));
                }
                if (policy.getRuleCount() > 0) {
                    System.out.println("    Rules:");
                    policy.getRules().forEach(rule -> System.out.println("      - " + String.valueOf(rule)));
                }
                if (policy.getExpiresAt().isPresent()) {
                    System.out.println("    Expires: " + String.valueOf(policy.getExpiresAt().get()));
                }
                System.out.println();
            }
            System.out.println("\u2500".repeat(70));
            System.out.println("Total: " + policies.size() + " policies (" + activeCount + " active)");
            return 0;
        }
        catch (Exception e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            System.err.println("Error: " + message);
            return 1;
        }
    }

    private String getFilterDescription() {
        if (this.validOnly) {
            return "valid only";
        }
        if (this.activeOnly) {
            return "active only";
        }
        return "all policies";
    }

    private String truncate(String value, int maxLength) {
        if (value == null) {
            return "";
        }
        if (value.length() <= maxLength) {
            return value;
        }
        return value.substring(0, maxLength - 3) + "...";
    }
}

