/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.application.usecases.policy.ListPoliciesUseCase;
import xyz.tcheeric.identity.domain.PolicyRule;
import xyz.tcheeric.identity.domain.SigningPolicy;

@CommandLine.Command(name="show", description={"Show details of a signing policy"}, mixinStandardHelpOptions=true)
public class PolicyShowCommand
implements Callable<Integer> {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final ListPoliciesUseCase useCase;
    @CommandLine.Parameters(index="0", description={"Policy ID"}, arity="1")
    private String policyId;
    @CommandLine.Option(names={"--json"}, description={"Output in JSON format"})
    private boolean jsonOutput;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    public PolicyShowCommand() {
        this.useCase = null;
    }

    public PolicyShowCommand(ListPoliciesUseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public Integer call() {
        try {
            if (this.useCase == null) {
                System.err.println("Error: Bunker connection not available");
                System.err.println("Run 'identity bunker configure' first to set up bunker connection");
                return 1;
            }
            System.out.println("Fetching policy details from bunker...");
            Optional<SigningPolicy> optionalPolicy = this.useCase.getById(this.policyId).join();
            if (optionalPolicy.isEmpty()) {
                System.err.println("Error: Policy not found: " + this.policyId);
                return 1;
            }
            SigningPolicy policy = optionalPolicy.get();
            if (this.jsonOutput) {
                this.displayJson(policy);
            } else {
                this.displayFormatted(policy);
            }
            return 0;
        }
        catch (Exception e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            System.err.println("Error: " + message);
            return 1;
        }
    }

    private void displayFormatted(SigningPolicy policy) {
        System.out.println();
        System.out.println("\u2550".repeat(60));
        System.out.println("Policy: " + policy.getName());
        System.out.println("\u2550".repeat(60));
        System.out.println("ID:          " + policy.getId());
        System.out.println("Name:        " + policy.getName());
        if (policy.getDescription() != null) {
            System.out.println("Description: " + String.valueOf(policy.getDescription()));
        }
        System.out.println();
        System.out.println("Status:      " + (policy.isActive() ? "Active" : "Inactive"));
        System.out.println("Valid:       " + (policy.isValid() ? "yes" : "no"));
        System.out.println("Expired:     " + (policy.isExpired() ? "yes" : "no"));
        if (policy.getCreatedAt() != null) {
            System.out.println("Created:     " + DATE_FORMAT.format(policy.getCreatedAt()));
        }
        if (policy.getExpiresAt().isPresent()) {
            System.out.println("Expires:     " + DATE_FORMAT.format(policy.getExpiresAt().get()));
        }
        System.out.println();
        System.out.println("Rules (" + policy.getRuleCount() + "):");
        if (policy.getRuleCount() == 0) {
            System.out.println("  (No rules - allows all operations)");
        } else {
            for (PolicyRule rule : policy.getRules()) {
                this.displayRule(rule);
            }
        }
        System.out.println("\u2550".repeat(60));
    }

    private void displayRule(PolicyRule rule) {
        StringBuilder sb = new StringBuilder("  ");
        sb.append(rule.isAllow() ? "[ALLOW] " : "[DENY]  ");
        if (rule.isMethodRule()) {
            sb.append("method: ").append(rule.getMethod().orElse("unknown"));
        } else if (rule.isEventKindRule()) {
            sb.append("kind: ").append(rule.getEventKind().orElse(-1));
            sb.append(" (").append(this.getKindDescription(rule.getEventKind().orElse(-1))).append(")");
        }
        if (rule.hasUsageLimit()) {
            sb.append(" [usage: ").append(rule.getCurrentUsage()).append("/").append(rule.getMaxUsage().orElse(0L)).append("]");
        }
        rule.getDescription().ifPresent(desc -> sb.append(" - ").append((String)desc));
        System.out.println(sb);
    }

    private String getKindDescription(int kind) {
        return switch (kind) {
            case 0 -> "metadata";
            case 1 -> "short text note";
            case 2 -> "recommend relay";
            case 3 -> "contacts";
            case 4 -> "encrypted direct message";
            case 5 -> "event deletion";
            case 6 -> "repost";
            case 7 -> "reaction";
            case 8 -> "badge award";
            case 40 -> "channel creation";
            case 41 -> "channel metadata";
            case 42 -> "channel message";
            case 43 -> "channel hide message";
            case 44 -> "channel mute user";
            case 1984 -> "reporting";
            case 9734 -> "zap request";
            case 9735 -> "zap";
            case 10000 -> "mute list";
            case 10001 -> "pin list";
            case 10002 -> "relay list metadata";
            case 30000 -> "categorized people list";
            case 30001 -> "categorized bookmark list";
            case 30023 -> "long-form content";
            default -> "custom";
        };
    }

    private void displayJson(SigningPolicy policy) {
        System.out.println("{");
        System.out.println("  \"id\": \"" + policy.getId() + "\",");
        System.out.println("  \"name\": \"" + policy.getName() + "\",");
        policy.getDescription().ifPresent(desc -> System.out.println("  \"description\": \"" + this.escapeJson((String)desc) + "\","));
        System.out.println("  \"active\": " + policy.isActive() + ",");
        System.out.println("  \"valid\": " + policy.isValid() + ",");
        System.out.println("  \"expired\": " + policy.isExpired() + ",");
        if (policy.getCreatedAt() != null) {
            System.out.println("  \"created_at\": \"" + String.valueOf(policy.getCreatedAt()) + "\",");
        }
        if (policy.getExpiresAt().isPresent()) {
            System.out.println("  \"expires_at\": \"" + String.valueOf(policy.getExpiresAt().get()) + "\",");
        }
        System.out.println("  \"rule_count\": " + policy.getRuleCount() + ",");
        System.out.println("  \"rules\": [");
        PolicyRule[] rules = policy.getRules().toArray(new PolicyRule[0]);
        for (int i2 = 0; i2 < rules.length; ++i2) {
            PolicyRule rule = rules[i2];
            System.out.print("    {");
            System.out.print("\"type\": \"" + (rule.isAllow() ? "allow" : "deny") + "\"");
            if (rule.isMethodRule()) {
                System.out.print(", \"method\": \"" + rule.getMethod().orElse("") + "\"");
            } else if (rule.isEventKindRule()) {
                System.out.print(", \"kind\": " + String.valueOf(rule.getEventKind().orElse(-1)));
            }
            if (rule.hasUsageLimit()) {
                System.out.print(", \"max_usage\": " + String.valueOf(rule.getMaxUsage().orElse(0L)));
                System.out.print(", \"current_usage\": " + rule.getCurrentUsage());
            }
            System.out.print("}");
            if (i2 < rules.length - 1) {
                System.out.println(",");
                continue;
            }
            System.out.println();
        }
        System.out.println("  ]");
        System.out.println("}");
    }

    private String escapeJson(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }
}

