/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picocli.CommandLine;
import xyz.tcheeric.identity.application.usecases.token.CreateAccessTokenUseCase;
import xyz.tcheeric.identity.domain.AccessToken;

@CommandLine.Command(name="create", description={"Create a new access token"}, mixinStandardHelpOptions=true)
public class TokenCreateCommand
implements Callable<Integer> {
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(\\d+)([dhms])$", 2);
    private final CreateAccessTokenUseCase useCase;
    @CommandLine.Parameters(index="0", description={"Name of the key to create a token for"}, arity="1")
    private String keyName;
    @CommandLine.Option(names={"-c", "--client"}, description={"Client name/description"}, required=true)
    private String clientName;
    @CommandLine.Option(names={"-p", "--policy"}, description={"Policy ID to attach to this token"})
    private String policyId;
    @CommandLine.Option(names={"--expires-in"}, description={"Token expiration (e.g., '30d' for 30 days, '24h' for 24 hours)"})
    private String expiresIn;
    @CommandLine.Option(names={"--max-usage"}, description={"Maximum number of times this token can be used"})
    private Long maxUsage;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    public TokenCreateCommand() {
        this.useCase = null;
    }

    public TokenCreateCommand(CreateAccessTokenUseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public Integer call() {
        try {
            if (this.useCase == null) {
                System.err.println("Error: Bunker connection not available");
                System.err.println("Run 'identity bunker configure' first to set up bunker connection");
                return 1;
            }
            Duration lifetime = this.parseExpiration(this.expiresIn);
            System.out.println("Creating access token...");
            System.out.println("  Key:       " + this.keyName);
            System.out.println("  Client:    " + this.clientName);
            if (this.policyId != null) {
                System.out.println("  Policy:    " + this.policyId);
            }
            if (lifetime != null) {
                System.out.println("  Expires:   " + this.formatDuration(lifetime));
            }
            if (this.maxUsage != null) {
                System.out.println("  Max usage: " + this.maxUsage);
            }
            CreateAccessTokenUseCase.CreateTokenRequest request = new CreateAccessTokenUseCase.CreateTokenRequest(this.keyName, this.clientName, this.policyId, lifetime);
            AccessToken token = this.useCase.execute(request).join();
            System.out.println();
            System.out.println("\u2550".repeat(60));
            System.out.println("Token created successfully!");
            System.out.println("\u2550".repeat(60));
            System.out.println();
            System.out.println("Token ID:     " + token.getId());
            System.out.println("Client:       " + token.getClientName());
            System.out.println("Key:          " + token.getKeyName());
            if (token.getPolicyId().isPresent()) {
                System.out.println("Policy:       " + token.getPolicyId().get());
            }
            if (token.getExpiresAt().isPresent()) {
                System.out.println("Expires:      " + String.valueOf(token.getExpiresAt().get()));
            }
            if (token.getConnectionString().isPresent()) {
                System.out.println();
                System.out.println("Connection string (bunker URL):");
                System.out.println("  " + token.getConnectionString().get());
                System.out.println();
                System.out.println("IMPORTANT: Save this connection string!");
                System.out.println("It cannot be retrieved later.");
            }
            System.out.println("\u2550".repeat(60));
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            System.err.println("Error: " + message);
            return 1;
        }
    }

    private Duration parseExpiration(String expirationStr) {
        String unit;
        if (expirationStr == null || expirationStr.isBlank()) {
            return null;
        }
        Matcher matcher = DURATION_PATTERN.matcher(expirationStr.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid expiration format: " + expirationStr + ". Use format like '30d' (days), '24h' (hours), '30m' (minutes), or '60s' (seconds)");
        }
        long value = Long.parseLong(matcher.group(1));
        return switch (unit = matcher.group(2).toLowerCase()) {
            case "d" -> Duration.ofDays(value);
            case "h" -> Duration.ofHours(value);
            case "m" -> Duration.ofMinutes(value);
            case "s" -> Duration.ofSeconds(value);
            default -> throw new IllegalArgumentException("Invalid duration unit: " + unit);
        };
    }

    private String formatDuration(Duration duration) {
        if (duration.toDays() > 0L) {
            return duration.toDays() + " day(s)";
        }
        if (duration.toHours() > 0L) {
            return duration.toHours() + " hour(s)";
        }
        if (duration.toMinutes() > 0L) {
            return duration.toMinutes() + " minute(s)";
        }
        return duration.toSeconds() + " second(s)";
    }
}

