/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.application.usecases.token.ListAccessTokensUseCase;
import xyz.tcheeric.identity.domain.AccessToken;

@CommandLine.Command(name="list", description={"List access tokens for a key"}, mixinStandardHelpOptions=true)
public class TokenListCommand
implements Callable<Integer> {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final ListAccessTokensUseCase useCase;
    @CommandLine.Parameters(index="0", description={"Name of the key to list tokens for"}, arity="1")
    private String keyName;
    @CommandLine.Option(names={"--active-only"}, description={"Only show active (non-revoked, non-expired) tokens"})
    private boolean activeOnly;
    @CommandLine.Option(names={"--revoked-only"}, description={"Only show revoked tokens"})
    private boolean revokedOnly;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Show detailed information"})
    private boolean verbose;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    public TokenListCommand() {
        this.useCase = null;
    }

    public TokenListCommand(ListAccessTokensUseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public Integer call() {
        try {
            if (this.useCase == null) {
                System.err.println("Error: Bunker connection not available");
                System.err.println("Run 'identity bunker configure' first to set up bunker connection");
                return 1;
            }
            System.out.println("Listing tokens for key: " + this.keyName);
            System.out.println("  Filter: " + this.getFilterDescription());
            ListAccessTokensUseCase.TokenFilter filter2 = ListAccessTokensUseCase.TokenFilter.all();
            if (this.activeOnly) {
                filter2 = ListAccessTokensUseCase.TokenFilter.onlyActive();
            } else if (this.revokedOnly) {
                filter2 = ListAccessTokensUseCase.TokenFilter.onlyRevoked();
            }
            List<AccessToken> tokens = this.useCase.execute(this.keyName, filter2).join();
            if (tokens.isEmpty()) {
                System.out.println("\nNo tokens found.");
                return 0;
            }
            System.out.println();
            System.out.println("\u2500".repeat(80));
            System.out.printf("%-16s %-20s %-10s %-12s %-12s%n", "ID", "CLIENT", "VALID", "USAGE", "EXPIRES");
            System.out.println("\u2500".repeat(80));
            int activeCount = 0;
            int revokedCount = 0;
            for (AccessToken token : tokens) {
                boolean isValid = token.isValid();
                boolean isRevoked = token.isRevoked();
                if (isValid) {
                    ++activeCount;
                }
                if (isRevoked) {
                    ++revokedCount;
                }
                String validStatus = isRevoked ? "revoked" : (isValid ? "yes" : "expired");
                String usageStr = this.formatUsage(token);
                String expiresStr = token.getExpiresAt().map(exp -> DATE_FORMAT.format((TemporalAccessor)exp)).orElse("never");
                System.out.printf("%-16s %-20s %-10s %-12s %-12s%n", this.truncate(token.getId(), 16), this.truncate(token.getClientName(), 20), validStatus, usageStr, expiresStr);
                if (!this.verbose) continue;
                if (token.getPolicyId().isPresent()) {
                    System.out.println("    Policy: " + token.getPolicyId().get());
                }
                if (token.getCreatedAt() != null) {
                    System.out.println("    Created: " + String.valueOf(token.getCreatedAt()));
                }
                if (token.getLastUsedAt().isPresent()) {
                    System.out.println("    Last used: " + String.valueOf(token.getLastUsedAt().get()));
                }
                System.out.println();
            }
            System.out.println("\u2500".repeat(80));
            System.out.println("Total: " + tokens.size() + " tokens (" + activeCount + " active, " + revokedCount + " revoked)");
            return 0;
        }
        catch (Exception e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            System.err.println("Error: " + message);
            return 1;
        }
    }

    private String getFilterDescription() {
        if (this.revokedOnly) {
            return "revoked only";
        }
        if (this.activeOnly) {
            return "active only";
        }
        return "all tokens";
    }

    private String formatUsage(AccessToken token) {
        long current = token.getUsageCount();
        return token.getMaxUsage().map(max -> current + "/" + max).orElse(current + "/\u221e");
    }

    private String truncate(String value, int maxLength) {
        if (value == null) {
            return "";
        }
        if (value.length() <= maxLength) {
            return value;
        }
        return value.substring(0, maxLength - 3) + "...";
    }
}

