/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.application.usecases.token.RevokeAccessTokenUseCase;
import xyz.tcheeric.identity.cli.util.PasswordPrompt;

@CommandLine.Command(name="revoke", description={"Revoke an access token"}, mixinStandardHelpOptions=true)
public class TokenRevokeCommand
implements Callable<Integer> {
    private final RevokeAccessTokenUseCase useCase;
    @CommandLine.Parameters(index="0", description={"Token ID to revoke"}, arity="0..1")
    private String tokenId;
    @CommandLine.Option(names={"-k", "--key"}, description={"Key name (for revoking all tokens)"})
    private String keyName;
    @CommandLine.Option(names={"--all"}, description={"Revoke all tokens for the specified key"})
    private boolean revokeAll;
    @CommandLine.Option(names={"-f", "--force"}, description={"Skip confirmation prompt"})
    private boolean force;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    public TokenRevokeCommand() {
        this.useCase = null;
    }

    public TokenRevokeCommand(RevokeAccessTokenUseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public Integer call() {
        try {
            if (this.useCase == null) {
                System.err.println("Error: Bunker connection not available");
                System.err.println("Run 'identity bunker configure' first to set up bunker connection");
                return 1;
            }
            if (this.revokeAll && this.keyName == null) {
                System.err.println("Error: --key is required when using --all");
                return 1;
            }
            if (!this.revokeAll && this.tokenId == null) {
                System.err.println("Error: Token ID is required (or use --all --key)");
                return 1;
            }
            if (this.revokeAll) {
                return this.revokeAllTokens();
            }
            return this.revokeSingleToken();
        }
        catch (IllegalStateException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            System.err.println("Error: " + message);
            return 1;
        }
    }

    private Integer revokeSingleToken() throws Exception {
        RevokeAccessTokenUseCase.RevokeTokenResult result;
        System.out.println("Revoking token...");
        System.out.println("  Token ID: " + this.tokenId);
        if (!this.force) {
            System.out.println();
            System.out.println("WARNING: This action cannot be undone.");
            System.out.println("The token will no longer be able to request signatures.");
            String response = PasswordPrompt.promptForText("Type 'REVOKE' to confirm: ");
            if (!"REVOKE".equals(response)) {
                System.out.println("Cancelled.");
                return 0;
            }
        }
        if ((result = this.useCase.execute(this.tokenId).join()).success()) {
            System.out.println();
            if (result.alreadyRevoked()) {
                System.out.println("Token was already revoked.");
            } else {
                System.out.println("Token revoked successfully.");
            }
            if (result.keyName() != null) {
                System.out.println("  Key: " + result.keyName());
            }
            if (result.clientName() != null) {
                System.out.println("  Client: " + result.clientName());
            }
        } else {
            Object errorMsg = result.errorMessage() != null ? result.errorMessage() : "Token not found or could not be revoked: " + this.tokenId;
            System.err.println("Error: " + (String)errorMsg);
            return 1;
        }
        return 0;
    }

    private Integer revokeAllTokens() throws Exception {
        System.out.println("Revoking all tokens for key...");
        System.out.println("  Key: " + this.keyName);
        if (!this.force) {
            System.out.println();
            System.out.println("WARNING: This will revoke ALL tokens for this key!");
            System.out.println("All clients using these tokens will lose access.");
            String response = PasswordPrompt.promptForText("Type 'REVOKE ALL' to confirm: ");
            if (!"REVOKE ALL".equals(response)) {
                System.out.println("Cancelled.");
                return 0;
            }
        }
        RevokeAccessTokenUseCase.BulkRevokeResult result = this.useCase.revokeAllForKey(this.keyName).join();
        System.out.println();
        if (result.revoked() > 0) {
            System.out.println("Revoked " + result.revoked() + " of " + result.attempted() + " token(s) for key '" + this.keyName + "'");
            if (result.isPartialSuccess()) {
                System.out.println("Warning: Some tokens could not be revoked.");
            }
        } else if (result.attempted() == 0) {
            System.out.println("No active tokens found for key '" + this.keyName + "'");
        } else {
            System.err.println("Error: Failed to revoke tokens for key '" + this.keyName + "'");
            if (result.error() != null) {
                System.err.println("  " + result.error());
            }
            return 1;
        }
        return 0;
    }
}

