/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.bunker;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.application.usecases.token.ListAccessTokensUseCase;
import xyz.tcheeric.identity.domain.AccessToken;

@CommandLine.Command(name="show", description={"Show details of an access token"}, mixinStandardHelpOptions=true)
public class TokenShowCommand
implements Callable<Integer> {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final ListAccessTokensUseCase useCase;
    @CommandLine.Parameters(index="0", description={"Token ID"}, arity="1")
    private String tokenId;
    @CommandLine.Option(names={"--json"}, description={"Output in JSON format"})
    private boolean jsonOutput;
    @CommandLine.Option(names={"--storage-dir"}, description={"Identity storage directory"}, defaultValue="${env:HOME}/.cashu/identities")
    private String storageDir;

    public TokenShowCommand() {
        this.useCase = null;
    }

    public TokenShowCommand(ListAccessTokensUseCase useCase) {
        this.useCase = useCase;
    }

    @Override
    public Integer call() {
        try {
            if (this.useCase == null) {
                System.err.println("Error: Bunker connection not available");
                System.err.println("Run 'identity bunker configure' first to set up bunker connection");
                return 1;
            }
            System.out.println("Fetching token details from bunker...");
            Optional<AccessToken> optionalToken = this.useCase.getById(this.tokenId).join();
            if (optionalToken.isEmpty()) {
                System.err.println("Error: Token not found: " + this.tokenId);
                return 1;
            }
            AccessToken token = optionalToken.get();
            if (this.jsonOutput) {
                this.displayJson(token);
            } else {
                this.displayFormatted(token);
            }
            return 0;
        }
        catch (Exception e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            System.err.println("Error: " + message);
            return 1;
        }
    }

    private void displayFormatted(AccessToken token) {
        System.out.println();
        System.out.println("\u2550".repeat(50));
        System.out.println("Token: " + this.truncate(token.getId(), 30));
        System.out.println("\u2550".repeat(50));
        System.out.println("ID:          " + token.getId());
        System.out.println("Key:         " + token.getKeyName());
        System.out.println("Client:      " + token.getClientName());
        token.getPolicyId().ifPresent(policyId -> System.out.println("Policy:      " + policyId));
        System.out.println();
        String status = token.isRevoked() ? "Revoked" : (!token.isValid() ? "Expired" : "Valid");
        System.out.println("Status:      " + status);
        if (token.getCreatedAt() != null) {
            System.out.println("Created:     " + DATE_FORMAT.format(token.getCreatedAt()));
        }
        token.getExpiresAt().ifPresent(exp -> System.out.println("Expires:     " + DATE_FORMAT.format((TemporalAccessor)exp)));
        token.getLastUsedAt().ifPresent(lastUsed -> System.out.println("Last used:   " + DATE_FORMAT.format((TemporalAccessor)lastUsed)));
        System.out.println();
        long current = token.getUsageCount();
        String usageStr = token.getMaxUsage().map(max -> current + " / " + max + " (" + (max - current) + " remaining)").orElse(current + " (unlimited)");
        System.out.println("Usage:       " + usageStr);
        System.out.println("\u2550".repeat(50));
    }

    private void displayJson(AccessToken token) {
        System.out.println("{");
        System.out.println("  \"id\": \"" + token.getId() + "\",");
        System.out.println("  \"key_name\": \"" + token.getKeyName() + "\",");
        System.out.println("  \"client_name\": \"" + this.escapeJson(token.getClientName()) + "\",");
        token.getPolicyId().ifPresent(policyId -> System.out.println("  \"policy_id\": \"" + policyId + "\","));
        if (token.getCreatedAt() != null) {
            System.out.println("  \"created_at\": \"" + String.valueOf(token.getCreatedAt()) + "\",");
        }
        token.getExpiresAt().ifPresent(exp -> System.out.println("  \"expires_at\": \"" + String.valueOf(exp) + "\","));
        token.getLastUsedAt().ifPresent(lastUsed -> System.out.println("  \"last_used_at\": \"" + String.valueOf(lastUsed) + "\","));
        System.out.println("  \"usage_count\": " + token.getUsageCount() + ",");
        token.getMaxUsage().ifPresent(max -> System.out.println("  \"max_usage\": " + max + ","));
        System.out.println("  \"revoked\": " + token.isRevoked() + ",");
        System.out.println("  \"valid\": " + token.isValid());
        System.out.println("}");
    }

    private String truncate(String value, int maxLength) {
        if (value == null) {
            return "";
        }
        if (value.length() <= maxLength) {
            return value;
        }
        return value.substring(0, maxLength - 3) + "...";
    }

    private String escapeJson(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }
}

