/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.profile;

import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.ports.ProfilePort;

@CommandLine.Command(name="categories", description={"Get merchant categories"}, mixinStandardHelpOptions=true)
public class MerchantCategoriesCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Public key (hex format, 64 characters)"})
    private String pubkey;
    @CommandLine.Option(names={"--json"}, description={"Output as JSON array"})
    private boolean json;
    private final ProfilePort profilePort;

    public MerchantCategoriesCommand(ProfilePort profilePort) {
        this.profilePort = profilePort;
    }

    public MerchantCategoriesCommand() {
        this.profilePort = null;
    }

    @Override
    public Integer call() {
        if (this.profilePort == null) {
            System.err.println("Error: ProfilePort not configured. This command requires bunker connection.");
            return 1;
        }
        try {
            this.validatePubkey(this.pubkey);
            List<String> categories = this.profilePort.getMerchantCategories(this.pubkey).join();
            if (this.json) {
                String jsonArray = "[" + categories.stream().map(c -> "\"" + this.escapeJson((String)c) + "\"").reduce((a, b) -> a + ", " + b).orElse("") + "]";
                System.out.println(jsonArray);
            } else if (categories.isEmpty()) {
                System.out.println("(no categories)");
            } else {
                categories.forEach(System.out::println);
            }
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error getting merchant categories: " + e.getMessage());
            return 1;
        }
    }

    private String escapeJson(String value) {
        return value.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private void validatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() != 64 || !pubkey.matches("[0-9a-fA-F]+")) {
            throw new IllegalArgumentException("Invalid public key format: expected 64 hex characters");
        }
    }
}

