/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.profile;

import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.ports.ProfilePort;

@CommandLine.Command(name="disable", description={"Disable a merchant profile (sets active=false)"}, mixinStandardHelpOptions=true)
public class MerchantDisableCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Public key (hex format, 64 characters)"})
    private String pubkey;
    private final ProfilePort profilePort;

    public MerchantDisableCommand(ProfilePort profilePort) {
        this.profilePort = profilePort;
    }

    public MerchantDisableCommand() {
        this.profilePort = null;
    }

    @Override
    public Integer call() {
        if (this.profilePort == null) {
            System.err.println("Error: ProfilePort not configured. This command requires bunker connection.");
            return 1;
        }
        try {
            this.validatePubkey(this.pubkey);
            System.out.println("Disabling merchant profile for " + this.truncatePubkey(this.pubkey) + "...");
            this.profilePort.disableMerchant(this.pubkey).join();
            System.out.println("\u2713 Merchant profile disabled successfully");
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error disabling merchant profile: " + e.getMessage());
            return 1;
        }
    }

    private void validatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() != 64 || !pubkey.matches("[0-9a-fA-F]+")) {
            throw new IllegalArgumentException("Invalid public key format: expected 64 hex characters");
        }
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() <= 16) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }
}

