/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.profile;

import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.ports.ProfilePort;
import xyz.tcheeric.identity.domain.MerchantProfile;
import xyz.tcheeric.identity.domain.PaymentMethod;

@CommandLine.Command(name="get", description={"Get merchant profile for a public key"}, mixinStandardHelpOptions=true)
public class MerchantGetCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Public key (hex format, 64 characters)"})
    private String pubkey;
    @CommandLine.Option(names={"--json"}, description={"Output as JSON"})
    private boolean json;
    private final ProfilePort profilePort;

    public MerchantGetCommand(ProfilePort profilePort) {
        this.profilePort = profilePort;
    }

    public MerchantGetCommand() {
        this.profilePort = null;
    }

    @Override
    public Integer call() {
        if (this.profilePort == null) {
            System.err.println("Error: ProfilePort not configured. This command requires bunker connection.");
            return 1;
        }
        try {
            this.validatePubkey(this.pubkey);
            System.out.println("Fetching merchant profile for " + this.truncatePubkey(this.pubkey) + "...");
            MerchantProfile profile2 = this.profilePort.getMerchantProfile(this.pubkey).join().orElse(null);
            if (profile2 == null) {
                System.out.println("No merchant profile found for this public key.");
                return 0;
            }
            if (this.json) {
                this.printJson(profile2);
            } else {
                this.printFormatted(profile2);
            }
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error fetching merchant profile: " + e.getMessage());
            return 1;
        }
    }

    private void printFormatted(MerchantProfile profile2) {
        System.out.println("\nMerchant Profile:");
        System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        System.out.println("  Active:           " + (profile2.isActive() ? "\u2713 Yes" : "\u2717 No"));
        System.out.println("  Categories:       " + (profile2.hasCategories() ? String.join((CharSequence)", ", profile2.categories()) : "(none)"));
        profile2.getStoreDescription().ifPresent(v -> System.out.println("  Description:      " + v));
        profile2.getLocation().ifPresent(v -> System.out.println("  Location:         " + v));
        profile2.getOperatingHours().ifPresent(v -> System.out.println("  Operating Hours:  " + v));
        if (profile2.hasPaymentMethods()) {
            String methods = profile2.paymentMethods().stream().map(PaymentMethod::getDisplayName).reduce((a, b) -> a + ", " + b).orElse("(none)");
            System.out.println("  Payment Methods:  " + methods);
        } else {
            System.out.println("  Payment Methods:  (none)");
        }
        System.out.println();
    }

    private void printJson(MerchantProfile profile2) {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append("  \"active\": ").append(profile2.isActive()).append(",\n");
        sb.append("  \"categories\": [");
        if (profile2.hasCategories()) {
            sb.append(profile2.categories().stream().map(c -> "\"" + this.escapeJson((String)c) + "\"").reduce((a, b) -> a + ", " + b).orElse(""));
        }
        sb.append("],\n");
        profile2.getStoreDescription().ifPresent(v -> sb.append("  \"storeDescription\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        profile2.getLocation().ifPresent(v -> sb.append("  \"location\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        profile2.getOperatingHours().ifPresent(v -> sb.append("  \"operatingHours\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        sb.append("  \"paymentMethods\": [");
        if (profile2.hasPaymentMethods()) {
            sb.append(profile2.paymentMethods().stream().map(pm -> "\"" + pm.getCode() + "\"").reduce((a, b) -> a + ", " + b).orElse(""));
        }
        sb.append("]\n");
        sb.append("}");
        System.out.println(sb);
    }

    private String escapeJson(String value) {
        return value.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private void validatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() != 64 || !pubkey.matches("[0-9a-fA-F]+")) {
            throw new IllegalArgumentException("Invalid public key format: expected 64 hex characters");
        }
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() <= 16) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }
}

