/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.profile;

import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.ports.ProfilePort;

@CommandLine.Command(name="is-merchant", description={"Check if an identity has a merchant profile"}, mixinStandardHelpOptions=true)
public class MerchantIsMerchantCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Public key (hex format, 64 characters)"})
    private String pubkey;
    private final ProfilePort profilePort;

    public MerchantIsMerchantCommand(ProfilePort profilePort) {
        this.profilePort = profilePort;
    }

    public MerchantIsMerchantCommand() {
        this.profilePort = null;
    }

    @Override
    public Integer call() {
        if (this.profilePort == null) {
            System.err.println("Error: ProfilePort not configured. This command requires bunker connection.");
            return 1;
        }
        try {
            this.validatePubkey(this.pubkey);
            boolean isMerchant = this.profilePort.isMerchant(this.pubkey).join();
            System.out.println(isMerchant ? "true" : "false");
            return isMerchant ? 0 : 1;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 2;
        }
        catch (Exception e) {
            System.err.println("Error checking merchant status: " + e.getMessage());
            return 2;
        }
    }

    private void validatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() != 64 || !pubkey.matches("[0-9a-fA-F]+")) {
            throw new IllegalArgumentException("Invalid public key format: expected 64 hex characters");
        }
    }
}

