/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.profile;

import java.util.Set;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.ports.ProfilePort;
import xyz.tcheeric.identity.domain.PaymentMethod;

@CommandLine.Command(name="payment-methods", description={"Get merchant accepted payment methods"}, mixinStandardHelpOptions=true)
public class MerchantPaymentMethodsCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Public key (hex format, 64 characters)"})
    private String pubkey;
    @CommandLine.Option(names={"--json"}, description={"Output as JSON array"})
    private boolean json;
    @CommandLine.Option(names={"--codes"}, description={"Output codes instead of display names"})
    private boolean codes;
    private final ProfilePort profilePort;

    public MerchantPaymentMethodsCommand(ProfilePort profilePort) {
        this.profilePort = profilePort;
    }

    public MerchantPaymentMethodsCommand() {
        this.profilePort = null;
    }

    @Override
    public Integer call() {
        if (this.profilePort == null) {
            System.err.println("Error: ProfilePort not configured. This command requires bunker connection.");
            return 1;
        }
        try {
            this.validatePubkey(this.pubkey);
            Set<PaymentMethod> methods = this.profilePort.getMerchantPaymentMethods(this.pubkey).join();
            if (this.json) {
                String jsonArray = "[" + methods.stream().map(pm -> "\"" + (this.codes ? pm.getCode() : pm.getDisplayName()) + "\"").reduce((a, b) -> a + ", " + b).orElse("") + "]";
                System.out.println(jsonArray);
            } else if (methods.isEmpty()) {
                System.out.println("(no payment methods)");
            } else {
                methods.forEach(pm -> {
                    if (this.codes) {
                        System.out.println(pm.getCode());
                    } else {
                        System.out.println(pm.getDisplayName() + " (" + pm.getCode() + ")");
                    }
                });
            }
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error getting merchant payment methods: " + e.getMessage());
            return 1;
        }
    }

    private void validatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() != 64 || !pubkey.matches("[0-9a-fA-F]+")) {
            throw new IllegalArgumentException("Invalid public key format: expected 64 hex characters");
        }
    }
}

