/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.profile;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.ports.ProfilePort;
import xyz.tcheeric.identity.domain.MerchantProfile;
import xyz.tcheeric.identity.domain.PaymentMethod;

@CommandLine.Command(name="set", description={"Set/update merchant profile for a public key"}, mixinStandardHelpOptions=true)
public class MerchantSetCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Public key (hex format, 64 characters)"})
    private String pubkey;
    @CommandLine.Option(names={"--active"}, description={"Set merchant as active"}, defaultValue="true")
    private boolean active;
    @CommandLine.Option(names={"--inactive"}, description={"Set merchant as inactive"})
    private boolean inactive;
    @CommandLine.Option(names={"--categories"}, description={"Business categories (comma-separated)"}, split=",")
    private List<String> categories;
    @CommandLine.Option(names={"--description"}, description={"Store description"})
    private String storeDescription;
    @CommandLine.Option(names={"--location"}, description={"Physical location or service area"})
    private String location;
    @CommandLine.Option(names={"--hours"}, description={"Operating hours (e.g., 'Mon-Fri 9:00-17:00')"})
    private String operatingHours;
    @CommandLine.Option(names={"--payment-methods"}, description={"Accepted payment methods (comma-separated codes: lightning,ecash,credit_card,cash,mobile_money,bank_transfer,bitcoin_onchain,voucher)"}, split=",")
    private List<String> paymentMethods;
    private final ProfilePort profilePort;

    public MerchantSetCommand(ProfilePort profilePort) {
        this.profilePort = profilePort;
    }

    public MerchantSetCommand() {
        this.profilePort = null;
    }

    @Override
    public Integer call() {
        if (this.profilePort == null) {
            System.err.println("Error: ProfilePort not configured. This command requires bunker connection.");
            return 1;
        }
        try {
            this.validatePubkey(this.pubkey);
            System.out.println("Setting merchant profile for " + this.truncatePubkey(this.pubkey) + "...");
            boolean isActive = !this.inactive && this.active;
            Set<PaymentMethod> methods = this.parsePaymentMethods(this.paymentMethods);
            MerchantProfile existing = this.profilePort.getMerchantProfile(this.pubkey).join().orElse(MerchantProfile.inactive());
            MerchantProfile profile2 = MerchantProfile.builder().active(isActive).categories(this.categories != null ? this.categories : existing.categories()).storeDescription(this.storeDescription != null ? this.storeDescription : (String)existing.getStoreDescription().orElse(null)).location(this.location != null ? this.location : (String)existing.getLocation().orElse(null)).operatingHours(this.operatingHours != null ? this.operatingHours : (String)existing.getOperatingHours().orElse(null)).paymentMethods(!methods.isEmpty() ? methods : existing.paymentMethods()).build();
            this.profilePort.setMerchantProfile(this.pubkey, profile2).join();
            System.out.println("\u2713 Merchant profile updated successfully");
            System.out.println();
            System.out.println("  Active:           " + (isActive ? "\u2713 Yes" : "\u2717 No"));
            if (this.categories != null && !this.categories.isEmpty()) {
                System.out.println("  Categories:       " + String.join((CharSequence)", ", this.categories));
            }
            if (this.storeDescription != null) {
                System.out.println("  Description:      " + this.storeDescription);
            }
            if (this.location != null) {
                System.out.println("  Location:         " + this.location);
            }
            if (this.operatingHours != null) {
                System.out.println("  Operating Hours:  " + this.operatingHours);
            }
            if (!methods.isEmpty()) {
                String methodsStr = methods.stream().map(PaymentMethod::getDisplayName).collect(Collectors.joining(", "));
                System.out.println("  Payment Methods:  " + methodsStr);
            }
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error setting merchant profile: " + e.getMessage());
            return 1;
        }
    }

    private Set<PaymentMethod> parsePaymentMethods(List<String> codes) {
        if (codes == null || codes.isEmpty()) {
            return Set.of();
        }
        EnumSet<PaymentMethod> result = EnumSet.noneOf(PaymentMethod.class);
        for (String code : codes) {
            PaymentMethod.fromCode(code.trim().toLowerCase()).ifPresentOrElse(result::add, () -> System.err.println("Warning: Unknown payment method code: " + code));
        }
        return result;
    }

    private void validatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() != 64 || !pubkey.matches("[0-9a-fA-F]+")) {
            throw new IllegalArgumentException("Invalid public key format: expected 64 hex characters");
        }
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() <= 16) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }
}

