/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.profile;

import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.ports.ProfilePort;
import xyz.tcheeric.identity.domain.ProfileMetadata;

@CommandLine.Command(name="get", description={"Get profile metadata for a public key"}, mixinStandardHelpOptions=true)
public class ProfileGetCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Public key (hex format, 64 characters)"})
    private String pubkey;
    @CommandLine.Option(names={"--json"}, description={"Output as JSON"})
    private boolean json;
    @CommandLine.Option(names={"--relay"}, description={"Relay URL to query"}, defaultValue="ws://localhost:8080")
    private String relayUrl;
    private final ProfilePort profilePort;

    public ProfileGetCommand(ProfilePort profilePort) {
        this.profilePort = profilePort;
    }

    public ProfileGetCommand() {
        this.profilePort = null;
    }

    @Override
    public Integer call() {
        if (this.profilePort == null) {
            System.err.println("Error: ProfilePort not configured. This command requires bunker connection.");
            return 1;
        }
        try {
            this.validatePubkey(this.pubkey);
            System.out.println("Fetching profile for " + this.truncatePubkey(this.pubkey) + "...");
            ProfileMetadata metadata = this.profilePort.getProfile(this.pubkey).join().orElse(null);
            if (metadata == null || metadata.isEmpty()) {
                System.out.println("No profile found for this public key.");
                return 0;
            }
            if (this.json) {
                this.printJson(metadata);
            } else {
                this.printFormatted(metadata);
            }
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error fetching profile: " + e.getMessage());
            return 1;
        }
    }

    private void printFormatted(ProfileMetadata metadata) {
        System.out.println("\nProfile Metadata:");
        System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        metadata.getName().ifPresent(v -> System.out.println("  Name:     " + v));
        metadata.getAbout().ifPresent(v -> System.out.println("  About:    " + v));
        metadata.getPicture().ifPresent(v -> System.out.println("  Picture:  " + v));
        metadata.getNip05().ifPresent(v -> System.out.println("  NIP-05:   " + v));
        metadata.getLud16().ifPresent(v -> System.out.println("  LUD-16:   " + v));
        metadata.getBanner().ifPresent(v -> System.out.println("  Banner:   " + v));
        metadata.getWebsite().ifPresent(v -> System.out.println("  Website:  " + v));
        System.out.println();
    }

    private void printJson(ProfileMetadata metadata) {
        StringBuilder sb = new StringBuilder("{\n");
        metadata.getName().ifPresent(v -> sb.append("  \"name\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        metadata.getAbout().ifPresent(v -> sb.append("  \"about\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        metadata.getPicture().ifPresent(v -> sb.append("  \"picture\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        metadata.getNip05().ifPresent(v -> sb.append("  \"nip05\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        metadata.getLud16().ifPresent(v -> sb.append("  \"lud16\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        metadata.getBanner().ifPresent(v -> sb.append("  \"banner\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        metadata.getWebsite().ifPresent(v -> sb.append("  \"website\": \"").append(this.escapeJson((String)v)).append("\",\n"));
        if (sb.toString().endsWith(",\n")) {
            sb.setLength(sb.length() - 2);
            sb.append("\n");
        }
        sb.append("}");
        System.out.println(sb);
    }

    private String escapeJson(String value) {
        return value.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private void validatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() != 64 || !pubkey.matches("[0-9a-fA-F]+")) {
            throw new IllegalArgumentException("Invalid public key format: expected 64 hex characters");
        }
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() <= 16) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }
}

