/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.commands.profile;

import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.identity.api.ports.ProfilePort;
import xyz.tcheeric.identity.domain.ProfileMetadata;

@CommandLine.Command(name="set", description={"Set/update profile metadata for a public key"}, mixinStandardHelpOptions=true)
public class ProfileSetCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Public key (hex format, 64 characters)"})
    private String pubkey;
    @CommandLine.Option(names={"--name"}, description={"Display name"})
    private String name;
    @CommandLine.Option(names={"--about"}, description={"Biography or description"})
    private String about;
    @CommandLine.Option(names={"--picture"}, description={"Profile picture URL"})
    private String picture;
    @CommandLine.Option(names={"--nip05"}, description={"NIP-05 identifier (user@domain.com)"})
    private String nip05;
    @CommandLine.Option(names={"--lud16"}, description={"Lightning address"})
    private String lud16;
    @CommandLine.Option(names={"--banner"}, description={"Banner image URL"})
    private String banner;
    @CommandLine.Option(names={"--website"}, description={"Website URL"})
    private String website;
    @CommandLine.Option(names={"--relay"}, description={"Relay URL to publish to"}, defaultValue="ws://localhost:8080")
    private String relayUrl;
    private final ProfilePort profilePort;

    public ProfileSetCommand(ProfilePort profilePort) {
        this.profilePort = profilePort;
    }

    public ProfileSetCommand() {
        this.profilePort = null;
    }

    @Override
    public Integer call() {
        if (this.profilePort == null) {
            System.err.println("Error: ProfilePort not configured. This command requires bunker connection.");
            return 1;
        }
        try {
            this.validatePubkey(this.pubkey);
            if (this.name == null && this.about == null && this.picture == null && this.nip05 == null && this.lud16 == null && this.banner == null && this.website == null) {
                System.err.println("Error: At least one profile field must be specified.");
                System.err.println("Use --name, --about, --picture, --nip05, --lud16, --banner, or --website");
                return 1;
            }
            System.out.println("Updating profile for " + this.truncatePubkey(this.pubkey) + "...");
            ProfileMetadata existing = this.profilePort.getProfile(this.pubkey).join().orElse(ProfileMetadata.empty());
            ProfileMetadata metadata = ProfileMetadata.builder().name(this.name != null ? this.name : existing.name()).about(this.about != null ? this.about : existing.about()).picture(this.picture != null ? this.picture : existing.picture()).nip05(this.nip05 != null ? this.nip05 : existing.nip05()).lud16(this.lud16 != null ? this.lud16 : existing.lud16()).banner(this.banner != null ? this.banner : existing.banner()).website(this.website != null ? this.website : existing.website()).build();
            this.profilePort.updateProfile(this.pubkey, metadata).join();
            System.out.println("\u2713 Profile updated successfully");
            System.out.println();
            System.out.println("Updated fields:");
            if (this.name != null) {
                System.out.println("  Name:     " + this.name);
            }
            if (this.about != null) {
                System.out.println("  About:    " + this.about);
            }
            if (this.picture != null) {
                System.out.println("  Picture:  " + this.picture);
            }
            if (this.nip05 != null) {
                System.out.println("  NIP-05:   " + this.nip05);
            }
            if (this.lud16 != null) {
                System.out.println("  LUD-16:   " + this.lud16);
            }
            if (this.banner != null) {
                System.out.println("  Banner:   " + this.banner);
            }
            if (this.website != null) {
                System.out.println("  Website:  " + this.website);
            }
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error updating profile: " + e.getMessage());
            return 1;
        }
    }

    private void validatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() != 64 || !pubkey.matches("[0-9a-fA-F]+")) {
            throw new IllegalArgumentException("Invalid public key format: expected 64 hex characters");
        }
    }

    private String truncatePubkey(String pubkey) {
        if (pubkey == null || pubkey.length() <= 16) {
            return pubkey;
        }
        return pubkey.substring(0, 8) + "..." + pubkey.substring(pubkey.length() - 8);
    }
}

