/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.cli.util;

import java.io.Console;
import java.util.Arrays;
import java.util.Scanner;

public class PasswordPrompt {
    private static Scanner scanner = null;

    public static char[] promptForNewPassword(String prompt) {
        return PasswordPrompt.promptForNewPassword(prompt, 3);
    }

    public static char[] promptForNewPassword(String prompt, int maxAttempts) {
        Console console = System.console();
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            char[] password2;
            char[] password1 = PasswordPrompt.promptForPassword(prompt);
            if (Arrays.equals(password1, password2 = PasswordPrompt.promptForPassword("Confirm password: "))) {
                Arrays.fill(password2, '\u0000');
                return password1;
            }
            Arrays.fill(password1, '\u0000');
            Arrays.fill(password2, '\u0000');
            if (attempt >= maxAttempts) continue;
            System.err.println("Passwords do not match. Please try again.");
        }
        throw new IllegalStateException("Passwords did not match after " + maxAttempts + " attempts");
    }

    public static char[] promptForPassword(String prompt) {
        Console console = System.console();
        if (console != null) {
            return console.readPassword("%s", prompt);
        }
        if (scanner == null) {
            System.err.println("WARNING: Console not available. Password will be visible.");
            scanner = new Scanner(System.in);
        }
        System.out.print(prompt);
        return scanner.nextLine().toCharArray();
    }

    public static String promptForText(String prompt) {
        Console console = System.console();
        if (console != null) {
            return console.readLine("%s", prompt);
        }
        if (scanner == null) {
            scanner = new Scanner(System.in);
        }
        System.out.print(prompt);
        return scanner.nextLine();
    }

    public static boolean promptForConfirmation(String prompt, boolean defaultValue) {
        String suffix = defaultValue ? " [Y/n]: " : " [y/N]: ";
        String input = PasswordPrompt.promptForText(prompt + suffix).trim().toLowerCase();
        if (input.isEmpty()) {
            return defaultValue;
        }
        return input.equals("y") || input.equals("yes");
    }
}

