/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class AccessToken {
    private final String id;
    private final String token;
    private final String keyName;
    private final String keyNpub;
    private final String clientName;
    private final String policyId;
    private final String policyName;
    private final String relay;
    private final Instant createdAt;
    private final Instant expiresAt;
    private Instant lastUsedAt;
    private long usageCount;
    private final Long maxUsage;
    private boolean revoked;

    public AccessToken(String keyName, String clientName) {
        this(UUID.randomUUID().toString(), AccessToken.generateSecureToken(), keyName, null, clientName, null, null, null, Instant.now(), null, null, 0L, null, false);
    }

    public AccessToken(String id, String token, String keyName, String keyNpub, String clientName, String policyId, String policyName, String relay, Instant createdAt, Instant expiresAt, Instant lastUsedAt, long usageCount, Long maxUsage, boolean revoked) {
        this.id = Objects.requireNonNull(id, "Token ID cannot be null");
        this.token = Objects.requireNonNull(token, "Token string cannot be null");
        this.keyName = AccessToken.validateKeyName(keyName);
        this.keyNpub = keyNpub;
        this.clientName = AccessToken.validateClientName(clientName);
        this.policyId = policyId;
        this.policyName = policyName;
        this.relay = relay;
        this.createdAt = Objects.requireNonNull(createdAt, "Created timestamp cannot be null");
        this.expiresAt = expiresAt;
        this.lastUsedAt = lastUsedAt;
        this.usageCount = usageCount;
        this.maxUsage = maxUsage;
        this.revoked = revoked;
        if (maxUsage != null && maxUsage <= 0L) {
            throw new IllegalArgumentException("maxUsage must be positive if specified");
        }
        if (usageCount < 0L) {
            throw new IllegalArgumentException("usageCount cannot be negative");
        }
    }

    private static String generateSecureToken() {
        byte[] bytes = new byte[32];
        new SecureRandom().nextBytes(bytes);
        StringBuilder hex = new StringBuilder();
        for (byte b : bytes) {
            hex.append(String.format("%02x", b));
        }
        return hex.toString();
    }

    private static String validateKeyName(String keyName) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        String trimmed = keyName.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("Key name cannot be empty");
        }
        return trimmed;
    }

    private static String validateClientName(String clientName) {
        Objects.requireNonNull(clientName, "Client name cannot be null");
        String trimmed = clientName.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("Client name cannot be empty");
        }
        if (trimmed.length() > 100) {
            throw new IllegalArgumentException("Client name cannot exceed 100 characters");
        }
        return trimmed;
    }

    public AccessToken withKeyNpub(String npub) {
        return new AccessToken(this.id, this.token, this.keyName, npub, this.clientName, this.policyId, this.policyName, this.relay, this.createdAt, this.expiresAt, this.lastUsedAt, this.usageCount, this.maxUsage, this.revoked);
    }

    public AccessToken withPolicy(String policyId, String policyName) {
        return new AccessToken(this.id, this.token, this.keyName, this.keyNpub, this.clientName, policyId, policyName, this.relay, this.createdAt, this.expiresAt, this.lastUsedAt, this.usageCount, this.maxUsage, this.revoked);
    }

    public AccessToken withPolicyId(String policyId) {
        return this.withPolicy(policyId, this.policyName);
    }

    public AccessToken withRelay(String relayUrl) {
        return new AccessToken(this.id, this.token, this.keyName, this.keyNpub, this.clientName, this.policyId, this.policyName, relayUrl, this.createdAt, this.expiresAt, this.lastUsedAt, this.usageCount, this.maxUsage, this.revoked);
    }

    public AccessToken withExpiresAt(Instant expiry) {
        return new AccessToken(this.id, this.token, this.keyName, this.keyNpub, this.clientName, this.policyId, this.policyName, this.relay, this.createdAt, expiry, this.lastUsedAt, this.usageCount, this.maxUsage, this.revoked);
    }

    public AccessToken withExpiration(Duration duration) {
        return this.withExpiresAt(Instant.now().plus(duration));
    }

    public AccessToken withMaxUsage(long limit) {
        return new AccessToken(this.id, this.token, this.keyName, this.keyNpub, this.clientName, this.policyId, this.policyName, this.relay, this.createdAt, this.expiresAt, this.lastUsedAt, this.usageCount, limit, this.revoked);
    }

    public void recordUsage() {
        if (this.isUsageLimitReached()) {
            throw new IllegalStateException("Token usage limit reached");
        }
        this.lastUsedAt = Instant.now();
        ++this.usageCount;
    }

    public void revoke() {
        this.revoked = true;
    }

    public boolean isValid() {
        return !this.revoked && !this.isExpired() && !this.isUsageLimitReached();
    }

    public boolean isExpired() {
        return this.expiresAt != null && Instant.now().isAfter(this.expiresAt);
    }

    public boolean isUsageLimitReached() {
        return this.maxUsage != null && this.usageCount >= this.maxUsage;
    }

    public Optional<Duration> getTimeUntilExpiration() {
        if (this.expiresAt == null) {
            return Optional.empty();
        }
        Duration remaining = Duration.between(Instant.now(), this.expiresAt);
        return Optional.of(remaining.isNegative() ? Duration.ZERO : remaining);
    }

    public Optional<Long> getRemainingUsage() {
        if (this.maxUsage == null) {
            return Optional.empty();
        }
        return Optional.of(Math.max(0L, this.maxUsage - this.usageCount));
    }

    public boolean hasPolicy() {
        return this.policyId != null;
    }

    public boolean hasUsageLimit() {
        return this.maxUsage != null;
    }

    public Optional<String> getConnectionString() {
        if (this.keyNpub == null || this.relay == null) {
            return Optional.empty();
        }
        return Optional.of(String.format("bunker://%s?relay=%s&secret=%s", this.keyNpub, this.relay, this.token));
    }

    public String getFullToken() {
        return this.token;
    }

    public String getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Optional<String> getKeyNpub() {
        return Optional.ofNullable(this.keyNpub);
    }

    public String getClientName() {
        return this.clientName;
    }

    public Optional<String> getPolicyId() {
        return Optional.ofNullable(this.policyId);
    }

    public Optional<String> getPolicyName() {
        return Optional.ofNullable(this.policyName);
    }

    public Optional<String> getRelay() {
        return Optional.ofNullable(this.relay);
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Optional<Instant> getExpiresAt() {
        return Optional.ofNullable(this.expiresAt);
    }

    public Optional<Instant> getLastUsedAt() {
        return Optional.ofNullable(this.lastUsedAt);
    }

    public long getUsageCount() {
        return this.usageCount;
    }

    public Optional<Long> getMaxUsage() {
        return Optional.ofNullable(this.maxUsage);
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "AccessToken{id='" + this.id + "', keyName='" + this.keyName + "', clientName='" + this.clientName + "', policy=" + (this.policyId != null ? this.policyName : "none") + ", valid=" + this.isValid() + ", revoked=" + this.revoked + ", usage=" + this.usageCount + (String)(this.maxUsage != null ? "/" + this.maxUsage : "") + ", expiresAt=" + String.valueOf(this.expiresAt) + "}";
    }
}

