/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import xyz.tcheeric.identity.domain.IdentitySource;
import xyz.tcheeric.identity.domain.PublicKey;

public class BunkerIdentity {
    private final String id;
    private final String keyName;
    private final PublicKey publicKey;
    private final List<String> relays;
    private final boolean locked;
    private final String description;
    private final String lightningAddress;
    private final Instant createdAt;
    private Instant lastUsedAt;

    public BunkerIdentity(String keyName, PublicKey publicKey, List<String> relays, boolean locked, String description) {
        this(UUID.randomUUID().toString(), keyName, publicKey, relays, locked, description, null, Instant.now(), null);
    }

    public BunkerIdentity(String keyName, PublicKey publicKey, List<String> relays, boolean locked, String description, String lightningAddress) {
        this(UUID.randomUUID().toString(), keyName, publicKey, relays, locked, description, lightningAddress, Instant.now(), null);
    }

    public BunkerIdentity(String id, String keyName, PublicKey publicKey, List<String> relays, boolean locked, String description, String lightningAddress, Instant createdAt, Instant lastUsedAt) {
        this.id = Objects.requireNonNull(id, "Identity ID cannot be null");
        this.keyName = BunkerIdentity.validateKeyName(keyName);
        this.publicKey = Objects.requireNonNull(publicKey, "Public key cannot be null");
        this.relays = BunkerIdentity.validateRelays(relays);
        this.locked = locked;
        this.description = description;
        this.lightningAddress = lightningAddress;
        this.createdAt = Objects.requireNonNull(createdAt, "Created timestamp cannot be null");
        this.lastUsedAt = lastUsedAt;
    }

    private static String validateKeyName(String keyName) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        String trimmed = keyName.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("Key name cannot be empty");
        }
        if (trimmed.length() > 100) {
            throw new IllegalArgumentException("Key name cannot exceed 100 characters");
        }
        if (!trimmed.matches("^[a-zA-Z0-9_-]+$")) {
            throw new IllegalArgumentException("Key name must contain only alphanumeric characters, hyphens, and underscores");
        }
        return trimmed;
    }

    private static List<String> validateRelays(List<String> relays) {
        Objects.requireNonNull(relays, "Relays list cannot be null");
        if (relays.isEmpty()) {
            throw new IllegalArgumentException("At least one relay URL is required");
        }
        for (String relay : relays) {
            if (relay == null || relay.isBlank()) {
                throw new IllegalArgumentException("Relay URL cannot be null or empty");
            }
            if (relay.startsWith("wss://") || relay.startsWith("ws://")) continue;
            throw new IllegalArgumentException("Relay URL must start with wss:// or ws://: " + relay);
        }
        return Collections.unmodifiableList(List.copyOf(relays));
    }

    public IdentitySource getSource() {
        return IdentitySource.BUNKER;
    }

    public void markAsUsed() {
        this.lastUsedAt = Instant.now();
    }

    public BunkerIdentity withLocked(boolean newLocked) {
        return new BunkerIdentity(this.id, this.keyName, this.publicKey, this.relays, newLocked, this.description, this.lightningAddress, this.createdAt, this.lastUsedAt);
    }

    public BunkerIdentity withDescription(String newDescription) {
        return new BunkerIdentity(this.id, this.keyName, this.publicKey, this.relays, this.locked, newDescription, this.lightningAddress, this.createdAt, this.lastUsedAt);
    }

    public BunkerIdentity withLightningAddress(String newLightningAddress) {
        return new BunkerIdentity(this.id, this.keyName, this.publicKey, this.relays, this.locked, this.description, newLightningAddress, this.createdAt, this.lastUsedAt);
    }

    public boolean isActive() {
        Instant referenceTime = this.lastUsedAt != null ? this.lastUsedAt : this.createdAt;
        Instant ninetyDaysAgo = Instant.now().minusSeconds(7776000L);
        return referenceTime.isAfter(ninetyDaysAgo);
    }

    public boolean isDormant() {
        return !this.isActive();
    }

    public boolean canSign() {
        return !this.locked;
    }

    public String getId() {
        return this.id;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public List<String> getRelays() {
        return this.relays;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLightningAddress() {
        return this.lightningAddress;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getLastUsedAt() {
        return this.lastUsedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BunkerIdentity that = (BunkerIdentity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "BunkerIdentity{id='" + this.id + "', keyName='" + this.keyName + "', publicKey=" + this.publicKey.toHex().substring(0, Math.min(16, this.publicKey.toHex().length())) + "..., relays=" + this.relays.size() + " relay(s), locked=" + this.locked + ", createdAt=" + String.valueOf(this.createdAt) + ", lastUsedAt=" + String.valueOf(this.lastUsedAt) + ", active=" + this.isActive() + "}";
    }
}

