/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import nostr.base.ISignable;
import nostr.base.Signature;
import nostr.event.BaseEvent;
import xyz.tcheeric.identity.domain.PrivateKey;
import xyz.tcheeric.identity.domain.PublicKey;

public class Identity {
    private final String id;
    private final String label;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private final nostr.id.Identity nostrIdentity;
    private final Instant createdAt;
    private Instant lastUsedAt;

    public Identity(String label, PublicKey publicKey, PrivateKey privateKey) {
        this(UUID.randomUUID().toString(), label, publicKey, privateKey, Instant.now(), null);
    }

    public Identity(String id, String label, PublicKey publicKey, PrivateKey privateKey, Instant createdAt, Instant lastUsedAt) {
        this.id = Objects.requireNonNull(id, "Identity ID cannot be null");
        this.label = Identity.validateLabel(label);
        this.publicKey = Objects.requireNonNull(publicKey, "Public key cannot be null");
        this.privateKey = Objects.requireNonNull(privateKey, "Private key cannot be null");
        this.createdAt = Objects.requireNonNull(createdAt, "Created timestamp cannot be null");
        this.lastUsedAt = lastUsedAt;
        this.nostrIdentity = nostr.id.Identity.create(privateKey.toNostrJava());
    }

    private static String validateLabel(String label) {
        Objects.requireNonNull(label, "Identity label cannot be null");
        String trimmed = label.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("Identity label cannot be empty");
        }
        if (trimmed.length() > 100) {
            throw new IllegalArgumentException("Identity label cannot exceed 100 characters");
        }
        return trimmed;
    }

    public Signature sign(BaseEvent event) {
        Objects.requireNonNull(event, "Event cannot be null");
        this.markAsUsed();
        if (!(event instanceof ISignable)) {
            throw new IllegalArgumentException("Event must implement ISignable");
        }
        try {
            nostr.id.Identity nostrIdentity = nostr.id.Identity.create(this.privateKey.toNostrJava());
            return nostrIdentity.sign((ISignable)((Object)event));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to sign event: " + e.getMessage(), e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public void markAsUsed() {
        this.lastUsedAt = Instant.now();
    }

    public Identity withLabel(String newLabel) {
        return new Identity(this.id, newLabel, this.publicKey, this.privateKey, this.createdAt, this.lastUsedAt);
    }

    public boolean isActive() {
        Instant referenceTime = this.lastUsedAt != null ? this.lastUsedAt : this.createdAt;
        Instant ninetyDaysAgo = Instant.now().minusSeconds(7776000L);
        return referenceTime.isAfter(ninetyDaysAgo);
    }

    public boolean isDormant() {
        return !this.isActive();
    }

    public nostr.id.Identity getNostrIdentity() {
        return this.nostrIdentity;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getLastUsedAt() {
        return this.lastUsedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.id, identity.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "Identity{id='" + this.id + "', label='" + this.label + "', publicKey=" + this.publicKey.toString().substring(0, Math.min(20, this.publicKey.toString().length())) + "..., createdAt=" + String.valueOf(this.createdAt) + ", lastUsedAt=" + String.valueOf(this.lastUsedAt) + ", active=" + this.isActive() + "}";
    }
}

