/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import xyz.tcheeric.identity.domain.PaymentMethod;

public record MerchantProfile(boolean active, List<String> categories, String storeDescription, String location, String operatingHours, Set<PaymentMethod> paymentMethods) {
    public static final String D_TAG = "imani:merchant";
    public static final int KIND = 30078;

    public MerchantProfile {
        categories = categories != null ? List.copyOf(categories) : List.of();
        paymentMethods = paymentMethods != null && !paymentMethods.isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(paymentMethods)) : Set.of();
    }

    public static MerchantProfile inactive() {
        return new MerchantProfile(false, List.of(), null, null, null, Set.of());
    }

    public static MerchantProfile active(List<String> categories) {
        return new MerchantProfile(true, categories, null, null, null, Set.of());
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isMerchant() {
        return true;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean hasCategory(String category) {
        if (category == null || category.isBlank()) {
            return false;
        }
        String normalizedCategory = category.trim().toLowerCase();
        return this.categories.stream().map(String::toLowerCase).anyMatch(c -> c.equals(normalizedCategory));
    }

    public boolean hasCategories() {
        return !this.categories.isEmpty();
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public boolean acceptsPaymentMethod(PaymentMethod method) {
        return method != null && this.paymentMethods.contains((Object)method);
    }

    public boolean acceptsLightning() {
        return this.acceptsPaymentMethod(PaymentMethod.LIGHTNING);
    }

    public boolean acceptsEcash() {
        return this.acceptsPaymentMethod(PaymentMethod.ECASH);
    }

    public boolean acceptsCreditCard() {
        return this.acceptsPaymentMethod(PaymentMethod.CREDIT_CARD);
    }

    public boolean acceptsCash() {
        return this.acceptsPaymentMethod(PaymentMethod.CASH);
    }

    public boolean acceptsMobileMoney() {
        return this.acceptsPaymentMethod(PaymentMethod.MOBILE_MONEY);
    }

    public boolean acceptsBankTransfer() {
        return this.acceptsPaymentMethod(PaymentMethod.BANK_TRANSFER);
    }

    public boolean acceptsBitcoinOnchain() {
        return this.acceptsPaymentMethod(PaymentMethod.BITCOIN_ONCHAIN);
    }

    public boolean acceptsVoucher() {
        return this.acceptsPaymentMethod(PaymentMethod.VOUCHER);
    }

    public boolean hasPaymentMethods() {
        return !this.paymentMethods.isEmpty();
    }

    public Set<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    public Optional<String> getStoreDescription() {
        return Optional.ofNullable(this.storeDescription);
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public Optional<String> getOperatingHours() {
        return Optional.ofNullable(this.operatingHours);
    }

    public MerchantProfile withActive(boolean newActive) {
        return new MerchantProfile(newActive, this.categories, this.storeDescription, this.location, this.operatingHours, this.paymentMethods);
    }

    public MerchantProfile withCategories(List<String> newCategories) {
        return new MerchantProfile(this.active, newCategories, this.storeDescription, this.location, this.operatingHours, this.paymentMethods);
    }

    public MerchantProfile withStoreDescription(String newDescription) {
        return new MerchantProfile(this.active, this.categories, newDescription, this.location, this.operatingHours, this.paymentMethods);
    }

    public MerchantProfile withLocation(String newLocation) {
        return new MerchantProfile(this.active, this.categories, this.storeDescription, newLocation, this.operatingHours, this.paymentMethods);
    }

    public MerchantProfile withOperatingHours(String newOperatingHours) {
        return new MerchantProfile(this.active, this.categories, this.storeDescription, this.location, newOperatingHours, this.paymentMethods);
    }

    public MerchantProfile withPaymentMethods(Set<PaymentMethod> newPaymentMethods) {
        return new MerchantProfile(this.active, this.categories, this.storeDescription, this.location, this.operatingHours, newPaymentMethods);
    }

    public static class Builder {
        private boolean active = false;
        private List<String> categories = List.of();
        private String storeDescription;
        private String location;
        private String operatingHours;
        private Set<PaymentMethod> paymentMethods = Set.of();

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public Builder categories(String ... categories) {
            this.categories = List.of(categories);
            return this;
        }

        public Builder storeDescription(String storeDescription) {
            this.storeDescription = storeDescription;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder operatingHours(String operatingHours) {
            this.operatingHours = operatingHours;
            return this;
        }

        public Builder paymentMethods(Set<PaymentMethod> paymentMethods) {
            this.paymentMethods = paymentMethods;
            return this;
        }

        public Builder paymentMethods(PaymentMethod ... paymentMethods) {
            this.paymentMethods = paymentMethods.length > 0 ? EnumSet.copyOf(List.of(paymentMethods)) : Set.of();
            return this;
        }

        public MerchantProfile build() {
            return new MerchantProfile(this.active, this.categories, this.storeDescription, this.location, this.operatingHours, this.paymentMethods);
        }
    }
}

