/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.domain;

import java.util.List;
import java.util.Objects;
import xyz.tcheeric.identity.domain.Tag;

public final class NostrEvent {
    private final int kind;
    private final String content;
    private final String pubkey;
    private final List<Tag> tags;
    private final Long createdAt;
    private final String id;
    private final String sig;

    private NostrEvent(int kind, String content, String pubkey, List<Tag> tags, Long createdAt, String id, String sig) {
        this.kind = kind;
        this.content = Objects.requireNonNull(content, "content cannot be null");
        this.pubkey = Objects.requireNonNull(pubkey, "pubkey cannot be null");
        this.tags = tags != null ? List.copyOf(tags) : List.of();
        this.createdAt = createdAt;
        this.id = id;
        this.sig = sig;
    }

    public static NostrEvent createUnsigned(int kind, String content, String pubkey, List<Tag> tags) {
        return new NostrEvent(kind, content, pubkey, tags, null, null, null);
    }

    public static NostrEvent createUnsigned(int kind, String content, String pubkey, List<Tag> tags, Long createdAt) {
        return new NostrEvent(kind, content, pubkey, tags, createdAt, null, null);
    }

    public NostrEvent withSignature(String eventId, String signature) {
        if (this.isSigned()) {
            throw new IllegalArgumentException("Event is already signed");
        }
        return new NostrEvent(this.kind, this.content, this.pubkey, this.tags, this.createdAt, eventId, signature);
    }

    public NostrEvent withTimestamp(Long timestamp) {
        return new NostrEvent(this.kind, this.content, this.pubkey, this.tags, timestamp, this.id, this.sig);
    }

    public int kind() {
        return this.kind;
    }

    public String content() {
        return this.content;
    }

    public String pubkey() {
        return this.pubkey;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Long createdAt() {
        return this.createdAt;
    }

    public String id() {
        return this.id;
    }

    public String sig() {
        return this.sig;
    }

    public boolean isSigned() {
        return this.id != null && this.sig != null;
    }

    public String toJson() {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"kind\":").append(this.kind).append(",");
        json.append("\"content\":").append(NostrEvent.escapeJson(this.content)).append(",");
        json.append("\"pubkey\":").append(NostrEvent.escapeJson(this.pubkey)).append(",");
        json.append("\"tags\":[");
        for (int i2 = 0; i2 < this.tags.size(); ++i2) {
            if (i2 > 0) {
                json.append(",");
            }
            json.append("[");
            Tag tag = this.tags.get(i2);
            List<String> tagValues = tag.toList();
            for (int j = 0; j < tagValues.size(); ++j) {
                if (j > 0) {
                    json.append(",");
                }
                json.append(NostrEvent.escapeJson(tagValues.get(j)));
            }
            json.append("]");
        }
        json.append("],");
        if (this.createdAt != null) {
            json.append("\"created_at\":").append(this.createdAt);
        } else {
            json.append("\"created_at\":").append(System.currentTimeMillis() / 1000L);
        }
        if (this.id != null) {
            json.append(",\"id\":").append(NostrEvent.escapeJson(this.id));
        }
        if (this.sig != null) {
            json.append(",\"sig\":").append(NostrEvent.escapeJson(this.sig));
        }
        json.append("}");
        return json.toString();
    }

    private static String escapeJson(String value) {
        if (value == null) {
            return "null";
        }
        StringBuilder escaped = new StringBuilder("\"");
        block9: for (char c : value.toCharArray()) {
            switch (c) {
                case '\"': {
                    escaped.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    escaped.append("\\b");
                    continue block9;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block9;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block9;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block9;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        escaped.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    escaped.append(c);
                }
            }
        }
        escaped.append("\"");
        return escaped.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NostrEvent that = (NostrEvent)o;
        return this.kind == that.kind && Objects.equals(this.content, that.content) && Objects.equals(this.pubkey, that.pubkey) && Objects.equals(this.tags, that.tags) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.id, that.id) && Objects.equals(this.sig, that.sig);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.content, this.pubkey, this.tags, this.createdAt, this.id, this.sig);
    }

    public String toString() {
        return "NostrEvent{kind=" + this.kind + ", pubkey=" + (String)(this.pubkey != null ? this.pubkey.substring(0, Math.min(16, this.pubkey.length())) + "..." : "null") + ", content=" + (String)(this.content.length() > 20 ? this.content.substring(0, 20) + "..." : this.content) + ", tags=" + this.tags.size() + ", signed=" + this.isSigned() + "}";
    }
}

